/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.auth;

import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithDefaults;
import io.smallrye.config.WithParentName;
import io.smallrye.config.WithUnnamedKey;
import java.util.Map;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.service.auth.AuthenticationRealmConfiguration;

@ConfigMapping(prefix="polaris.authentication")
public interface AuthenticationConfiguration {
    public static final String DEFAULT_REALM_KEY = "<default>";

    @WithParentName
    @WithUnnamedKey(value="<default>")
    @WithDefaults
    public @WithUnnamedKey(value="<default>") Map<String, AuthenticationRealmConfiguration> realms();

    default public AuthenticationRealmConfiguration forRealm(RealmContext realmContext) {
        return this.forRealm(realmContext.getRealmIdentifier());
    }

    default public AuthenticationRealmConfiguration forRealm(String realmIdentifier) {
        return this.realms().containsKey(realmIdentifier) ? this.realms().get(realmIdentifier) : this.realms().get(DEFAULT_REALM_KEY);
    }
}

