/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v2_2.internal;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.Response;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.SqsMessage;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.SqsMessageImpl;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.SqsParentContext;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.SqsProcessRequest;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.TracingExecutionInterceptor;
import java.util.Iterator;
import javax.annotation.Nullable;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.services.sqs.model.Message;

class TracingIterator
implements Iterator<Message> {
    private final Iterator<Message> delegateIterator;
    private final Instrumenter<SqsProcessRequest, Response> instrumenter;
    private final ExecutionAttributes request;
    private final Response response;
    private final TracingExecutionInterceptor config;
    private final Context receiveContext;
    @Nullable
    private SqsProcessRequest currentRequest;
    @Nullable
    private Context currentContext;
    @Nullable
    private Scope currentScope;

    private TracingIterator(Iterator<Message> delegateIterator, Instrumenter<SqsProcessRequest, Response> instrumenter, ExecutionAttributes request, Response response, TracingExecutionInterceptor config, Context receiveContext) {
        this.delegateIterator = delegateIterator;
        this.instrumenter = instrumenter;
        this.request = request;
        this.response = response;
        this.config = config;
        this.receiveContext = receiveContext;
    }

    public static Iterator<Message> wrap(Iterator<Message> delegateIterator, Instrumenter<SqsProcessRequest, Response> instrumenter, ExecutionAttributes request, Response response, TracingExecutionInterceptor config, Context receiveContext) {
        return new TracingIterator(delegateIterator, instrumenter, request, response, config, receiveContext);
    }

    @Override
    public boolean hasNext() {
        this.closeScopeAndEndSpan();
        return this.delegateIterator.hasNext();
    }

    @Override
    public Message next() {
        this.closeScopeAndEndSpan();
        Message next = this.delegateIterator.next();
        if (next != null) {
            SqsMessage sqsMessage = SqsMessageImpl.wrap(next);
            Context parentContext = this.receiveContext;
            if (parentContext == null) {
                parentContext = SqsParentContext.ofMessage(sqsMessage, this.config);
            }
            this.currentRequest = SqsProcessRequest.create(this.request, sqsMessage);
            this.currentContext = this.instrumenter.start(parentContext, (Object)this.currentRequest);
            this.currentScope = this.currentContext.makeCurrent();
        }
        return next;
    }

    private void closeScopeAndEndSpan() {
        if (this.currentScope != null) {
            this.currentScope.close();
            this.instrumenter.end(this.currentContext, (Object)this.currentRequest, (Object)this.response, null);
            this.currentScope = null;
            this.currentRequest = null;
            this.currentContext = null;
        }
    }

    @Override
    public void remove() {
        this.delegateIterator.remove();
    }
}

