/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v2_2.internal;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.context.Context;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.protocols.jsoncore.JsonNode;
import software.amazon.awssdk.protocols.jsoncore.internal.ObjectJsonNode;
import software.amazon.awssdk.protocols.jsoncore.internal.StringJsonNode;
import software.amazon.awssdk.services.lambda.model.InvokeRequest;

final class LambdaImpl {
    private static final String CLIENT_CONTEXT_CUSTOM_FIELDS_KEY = "custom";
    static final int MAX_CLIENT_CONTEXT_LENGTH = 3583;

    private LambdaImpl() {
    }

    @Nullable
    static SdkRequest modifyRequest(SdkRequest request, Context otelContext) {
        if (LambdaImpl.isDirectLambdaInvocation(request)) {
            return LambdaImpl.modifyOrAddCustomContextHeader((InvokeRequest)request, otelContext);
        }
        return null;
    }

    static boolean isDirectLambdaInvocation(SdkRequest request) {
        return request instanceof InvokeRequest;
    }

    static SdkRequest modifyOrAddCustomContextHeader(InvokeRequest request, Context otelContext) {
        JsonNode jsonNode;
        InvokeRequest.Builder builder = request.toBuilder();
        String clientContextString = request.clientContext();
        String clientContextJsonString = "{}";
        if (clientContextString != null && !clientContextString.isEmpty()) {
            clientContextJsonString = new String(Base64.getDecoder().decode(clientContextString), StandardCharsets.UTF_8);
        }
        if (!(jsonNode = JsonNode.parser().parse(clientContextJsonString)).isObject()) {
            return null;
        }
        JsonNode customNode = jsonNode.asObject().computeIfAbsent(CLIENT_CONTEXT_CUSTOM_FIELDS_KEY, k -> new ObjectJsonNode(new LinkedHashMap()));
        if (!customNode.isObject()) {
            return null;
        }
        Map map = customNode.asObject();
        GlobalOpenTelemetry.getPropagators().getTextMapPropagator().inject(otelContext, (Object)map, (nodes, key, value) -> nodes.put(key, new StringJsonNode(value)));
        if (map.isEmpty()) {
            return null;
        }
        String newJson = jsonNode.toString();
        String newJson64 = Base64.getEncoder().encodeToString(newJson.getBytes(StandardCharsets.UTF_8));
        if (newJson64.length() >= 3583) {
            return null;
        }
        builder.clientContext(newJson64);
        return (SdkRequest)builder.build();
    }

    static {
        String invokeRequestName = InvokeRequest.class.getName();
        String string = JsonNode.class.getName();
    }
}

