/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoUnit;
import java.util.Locale;

public class DateTimeUtil {
    public static final OffsetDateTime EPOCH = Instant.ofEpochSecond(0L).atOffset(ZoneOffset.UTC);
    public static final LocalDate EPOCH_DAY = EPOCH.toLocalDate();
    public static final long MICROS_PER_MILLIS = 1000L;
    public static final long MICROS_PER_SECOND = 1000000L;
    private static final long NANOS_PER_SECOND = 1000000000L;
    private static final long NANOS_PER_MICRO = 1000L;
    private static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE_TIME).appendOffset("+HH:MM:ss", "+00:00").toFormatter(Locale.ROOT);

    private DateTimeUtil() {
    }

    public static LocalDate dateFromDays(int daysFromEpoch) {
        return ChronoUnit.DAYS.addTo(EPOCH_DAY, daysFromEpoch);
    }

    public static int daysFromDate(LocalDate date) {
        return (int)ChronoUnit.DAYS.between(EPOCH_DAY, date);
    }

    public static int daysFromInstant(Instant instant) {
        return (int)ChronoUnit.DAYS.between(EPOCH, instant.atOffset(ZoneOffset.UTC));
    }

    public static LocalTime timeFromMicros(long microFromMidnight) {
        return LocalTime.ofNanoOfDay(microFromMidnight * 1000L);
    }

    public static long microsFromTime(LocalTime time) {
        return time.toNanoOfDay() / 1000L;
    }

    public static LocalDateTime timestampFromMicros(long microsFromEpoch) {
        return ChronoUnit.MICROS.addTo(EPOCH, microsFromEpoch).toLocalDateTime();
    }

    public static LocalDateTime timestampFromNanos(long nanosFromEpoch) {
        return ChronoUnit.NANOS.addTo(EPOCH, nanosFromEpoch).toLocalDateTime();
    }

    public static long microsFromInstant(Instant instant) {
        return ChronoUnit.MICROS.between(EPOCH, instant.atOffset(ZoneOffset.UTC));
    }

    public static long microsFromTimestamp(LocalDateTime dateTime) {
        return ChronoUnit.MICROS.between(EPOCH, dateTime.atOffset(ZoneOffset.UTC));
    }

    public static long nanosFromTimestamp(LocalDateTime dateTime) {
        return ChronoUnit.NANOS.between(EPOCH, dateTime.atOffset(ZoneOffset.UTC));
    }

    public static long microsToMillis(long micros) {
        return Math.floorDiv(micros, 1000L);
    }

    public static long nanosToMicros(long nanos) {
        return Math.floorDiv(nanos, 1000L);
    }

    public static long microsToNanos(long micros) {
        return Math.multiplyExact(micros, 1000L);
    }

    public static OffsetDateTime timestamptzFromMicros(long microsFromEpoch) {
        return ChronoUnit.MICROS.addTo(EPOCH, microsFromEpoch);
    }

    public static OffsetDateTime timestamptzFromNanos(long nanosFromEpoch) {
        return ChronoUnit.NANOS.addTo(EPOCH, nanosFromEpoch);
    }

    public static long microsFromTimestamptz(OffsetDateTime dateTime) {
        return ChronoUnit.MICROS.between(EPOCH, dateTime);
    }

    public static long nanosFromTimestamptz(OffsetDateTime dateTime) {
        return ChronoUnit.NANOS.between(EPOCH, dateTime);
    }

    public static String formatTimestampMillis(long millis) {
        return Instant.ofEpochMilli(millis).toString().replace("Z", "+00:00");
    }

    public static String daysToIsoDate(int days) {
        return DateTimeUtil.dateFromDays(days).format(DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public static String microsToIsoTime(long micros) {
        return DateTimeUtil.timeFromMicros(micros).format(DateTimeFormatter.ISO_LOCAL_TIME);
    }

    public static String microsToIsoTimestamptz(long micros) {
        LocalDateTime localDateTime = DateTimeUtil.timestampFromMicros(micros);
        return localDateTime.atOffset(ZoneOffset.UTC).format(FORMATTER);
    }

    public static String nanosToIsoTimestamptz(long nanos) {
        LocalDateTime localDateTime = DateTimeUtil.timestampFromNanos(nanos);
        return localDateTime.atOffset(ZoneOffset.UTC).format(FORMATTER);
    }

    public static String microsToIsoTimestamp(long micros) {
        LocalDateTime localDateTime = DateTimeUtil.timestampFromMicros(micros);
        return localDateTime.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
    }

    public static String nanosToIsoTimestamp(long nanos) {
        LocalDateTime localDateTime = DateTimeUtil.timestampFromNanos(nanos);
        return localDateTime.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
    }

    public static int isoDateToDays(String dateString) {
        return DateTimeUtil.daysFromDate(LocalDate.parse(dateString, DateTimeFormatter.ISO_LOCAL_DATE));
    }

    public static long isoTimeToMicros(String timeString) {
        return DateTimeUtil.microsFromTime(LocalTime.parse(timeString, DateTimeFormatter.ISO_LOCAL_TIME));
    }

    public static long isoTimestamptzToMicros(String timestampString) {
        return DateTimeUtil.microsFromTimestamptz(OffsetDateTime.parse(timestampString, DateTimeFormatter.ISO_DATE_TIME));
    }

    public static long isoTimestamptzToNanos(CharSequence timestampString) {
        return DateTimeUtil.nanosFromTimestamptz(OffsetDateTime.parse(timestampString, DateTimeFormatter.ISO_DATE_TIME));
    }

    public static boolean isUTCTimestamptz(String timestampString) {
        OffsetDateTime offsetDateTime = OffsetDateTime.parse(timestampString, DateTimeFormatter.ISO_DATE_TIME);
        return offsetDateTime.getOffset().equals(ZoneOffset.UTC);
    }

    public static long isoTimestampToMicros(String timestampString) {
        return DateTimeUtil.microsFromTimestamp(LocalDateTime.parse(timestampString, DateTimeFormatter.ISO_LOCAL_DATE_TIME));
    }

    public static long isoTimestampToNanos(CharSequence timestampString) {
        return DateTimeUtil.nanosFromTimestamp(LocalDateTime.parse(timestampString, DateTimeFormatter.ISO_LOCAL_DATE_TIME));
    }

    public static int hoursToDays(int hours) {
        LocalDate date = EPOCH.toLocalDateTime().plusHours(hours).toLocalDate();
        return DateTimeUtil.daysFromDate(date);
    }

    public static int daysToYears(int days) {
        return DateTimeUtil.convertDays(days, ChronoUnit.YEARS);
    }

    public static int daysToMonths(int days) {
        return DateTimeUtil.convertDays(days, ChronoUnit.MONTHS);
    }

    private static int convertDays(int days, ChronoUnit granularity) {
        if (days >= 0) {
            LocalDate date = EPOCH_DAY.plusDays(days);
            return (int)granularity.between(EPOCH_DAY, date);
        }
        LocalDate date = EPOCH_DAY.plusDays(days + 1);
        return (int)granularity.between(EPOCH_DAY, date) - 1;
    }

    public static int microsToYears(long micros) {
        return DateTimeUtil.convertMicros(micros, ChronoUnit.YEARS);
    }

    public static int microsToMonths(long micros) {
        return DateTimeUtil.convertMicros(micros, ChronoUnit.MONTHS);
    }

    public static int microsToDays(long micros) {
        return DateTimeUtil.convertMicros(micros, ChronoUnit.DAYS);
    }

    public static int microsToHours(long micros) {
        return DateTimeUtil.convertMicros(micros, ChronoUnit.HOURS);
    }

    private static int convertMicros(long micros, ChronoUnit granularity) {
        if (micros >= 0L) {
            long epochSecond = Math.floorDiv(micros, 1000000L);
            long nanoAdjustment = Math.floorMod(micros, 1000000L) * 1000L;
            return (int)granularity.between(EPOCH, DateTimeUtil.toOffsetDateTime(epochSecond, nanoAdjustment));
        }
        long epochSecond = Math.floorDiv(micros, 1000000L);
        long nanoAdjustment = Math.floorMod(micros + 1L, 1000000L) * 1000L;
        return (int)granularity.between(EPOCH, DateTimeUtil.toOffsetDateTime(epochSecond, nanoAdjustment)) - 1;
    }

    public static int nanosToYears(long nanos) {
        return Math.toIntExact(DateTimeUtil.convertNanos(nanos, ChronoUnit.YEARS));
    }

    public static int nanosToMonths(long nanos) {
        return Math.toIntExact(DateTimeUtil.convertNanos(nanos, ChronoUnit.MONTHS));
    }

    public static int nanosToDays(long nanos) {
        return Math.toIntExact(DateTimeUtil.convertNanos(nanos, ChronoUnit.DAYS));
    }

    public static int nanosToHours(long nanos) {
        return Math.toIntExact(DateTimeUtil.convertNanos(nanos, ChronoUnit.HOURS));
    }

    private static long convertNanos(long nanos, ChronoUnit granularity) {
        if (nanos >= 0L) {
            long epochSecond = Math.floorDiv(nanos, 1000000000L);
            long nanoAdjustment = Math.floorMod(nanos, 1000000000L);
            return granularity.between(EPOCH, DateTimeUtil.toOffsetDateTime(epochSecond, nanoAdjustment));
        }
        long epochSecond = Math.floorDiv(nanos, 1000000000L);
        long nanoAdjustment = Math.floorMod(nanos + 1L, 1000000000L);
        return granularity.between(EPOCH, DateTimeUtil.toOffsetDateTime(epochSecond, nanoAdjustment)) - 1L;
    }

    private static OffsetDateTime toOffsetDateTime(long epochSecond, long nanoAdjustment) {
        return Instant.ofEpochSecond(epochSecond, nanoAdjustment).atOffset(ZoneOffset.UTC);
    }
}

