/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.traverser;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hugegraph.api.graph.GraphAPI;
import org.apache.hugegraph.api.traverser.TraversersAPI;
import org.apache.hugegraph.client.RestClient;
import org.apache.hugegraph.rest.RestResult;
import org.apache.hugegraph.structure.constant.Direction;
import org.apache.hugegraph.structure.traverser.Kneighbor;
import org.apache.hugegraph.structure.traverser.KneighborRequest;

public class KneighborAPI
extends TraversersAPI {
    public KneighborAPI(RestClient client, String graphSpace, String graph) {
        super(client, graphSpace, graph);
    }

    @Override
    protected String type() {
        return "kneighbor";
    }

    public Map<String, Object> get(Object sourceId, Direction direction, String label, int depth, long degree, long limit) {
        String source = GraphAPI.formatVertexId(sourceId, false);
        KneighborAPI.checkPositive(depth, "Depth of k-neighbor");
        KneighborAPI.checkDegree(degree);
        KneighborAPI.checkLimit(limit);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("source", source);
        params.put("direction", (Object)direction);
        params.put("label", label);
        params.put("max_depth", depth);
        params.put("max_degree", degree);
        params.put("limit", limit);
        RestResult result = this.client.get(this.path(), params);
        Map resMap = (Map)result.readObject(Map.class);
        List ids = (List)resMap.get("vertices");
        resMap.put("vertices", ids);
        return resMap;
    }

    public Kneighbor post(KneighborRequest request) {
        this.client.checkApiVersion("0.58", "customized kneighbor");
        RestResult result = this.client.post(this.path(), request);
        return (Kneighbor)result.readObject(Kneighbor.class);
    }
}

