/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.handler;

import org.apache.hugegraph.common.Response;
import org.apache.hugegraph.exception.ExternalException;
import org.apache.hugegraph.exception.GenericException;
import org.apache.hugegraph.exception.IllegalGremlinException;
import org.apache.hugegraph.exception.InternalException;
import org.apache.hugegraph.exception.ParameterizedException;
import org.apache.hugegraph.handler.MessageSourceHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class ExceptionAdvisor {
    private static final Logger log = LogManager.getLogger(ExceptionAdvisor.class);
    @Autowired
    private MessageSourceHandler messageSourceHandler;

    @ExceptionHandler(value={InternalException.class})
    @ResponseStatus(value=HttpStatus.OK)
    public Response exceptionHandler(InternalException e) {
        log.error("InternalException:", (Throwable)e);
        String message = this.handleMessage(e.getMessage(), e.args());
        return Response.builder().status(500).message(message).cause(e.getCause()).build();
    }

    @ExceptionHandler(value={ExternalException.class})
    @ResponseStatus(value=HttpStatus.OK)
    public Response exceptionHandler(ExternalException e) {
        log.error("ExternalException:", (Throwable)e);
        String message = this.handleMessage(e.getMessage(), e.args());
        return Response.builder().status(e.status()).message(message).cause(e.getCause()).build();
    }

    @ExceptionHandler(value={GenericException.class})
    @ResponseStatus(value=HttpStatus.OK)
    public Response exceptionHandler(GenericException e) {
        log.error("GenericException:", (Throwable)e);
        return Response.builder().status(400).message("Faied to connect the graph server. Please refer to the Hubble log for details.").cause(null).build();
    }

    @ExceptionHandler(value={ParameterizedException.class})
    @ResponseStatus(value=HttpStatus.OK)
    public Response exceptionHandler(ParameterizedException e) {
        log.error("ParameterizedException", (Throwable)e);
        String message = this.handleMessage(e.getMessage(), e.args());
        return Response.builder().status(400).message(message).cause(e.getCause()).build();
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.OK)
    public Response exceptionHandler(Exception e) {
        log.error("Exception:", (Throwable)e);
        String message = this.handleMessage(e.getMessage(), null);
        return Response.builder().status(400).message(message).cause(e.getCause()).build();
    }

    @ExceptionHandler(value={IllegalGremlinException.class})
    @ResponseStatus(value=HttpStatus.OK)
    public Response exceptionHandler(IllegalGremlinException e) {
        log.error("IllegalGremlinException:", (Throwable)e);
        String message = this.handleMessage(e.getMessage(), e.args());
        return Response.builder().status(460).message(message).cause(e.getCause()).build();
    }

    private String handleMessage(String message, Object[] args) {
        String[] strArgs = null;
        if (args != null && args.length > 0) {
            strArgs = new String[args.length];
            for (int i = 0; i < args.length; ++i) {
                strArgs[i] = args[i] != null ? args[i].toString() : "?";
            }
        }
        try {
            message = this.messageSourceHandler.getMessage(message, strArgs);
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
        return message;
    }
}

