/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.controller.schema;

import com.baomidou.mybatisplus.core.metadata.IPage;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hugegraph.common.Constant;
import org.apache.hugegraph.controller.schema.SchemaController;
import org.apache.hugegraph.entity.schema.ConflictCheckEntity;
import org.apache.hugegraph.entity.schema.ConflictDetail;
import org.apache.hugegraph.entity.schema.PropertyKeyEntity;
import org.apache.hugegraph.entity.schema.UsingCheckEntity;
import org.apache.hugegraph.exception.ExternalException;
import org.apache.hugegraph.service.schema.PropertyKeyService;
import org.apache.hugegraph.util.Ex;
import org.apache.hugegraph.util.HubbleUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1.2/graph-connections/{connId}/schema/propertykeys"})
public class PropertyKeyController
extends SchemaController {
    private static final Logger log = LogManager.getLogger(PropertyKeyController.class);
    @Autowired
    private PropertyKeyService service;

    @GetMapping
    public IPage<PropertyKeyEntity> list(@PathVariable(value="connId") int connId, @RequestParam(name="content", required=false) String content, @RequestParam(name="name_order", required=false) String nameOrder, @RequestParam(name="page_no", required=false, defaultValue="1") int pageNo, @RequestParam(name="page_size", required=false, defaultValue="10") int pageSize) {
        return this.listInPage(id -> this.service.list((int)id), connId, content, nameOrder, pageNo, pageSize);
    }

    @GetMapping(value={"{name}"})
    public PropertyKeyEntity get(@PathVariable(value="connId") int connId, @PathVariable(value="name") String name) {
        return this.service.get(name, connId);
    }

    @PostMapping
    public void create(@PathVariable(value="connId") int connId, @RequestBody PropertyKeyEntity entity) {
        this.checkParamsValid(entity, true);
        this.checkEntityUnique(entity, connId);
        entity.setCreateTime(HubbleUtil.nowDate());
        this.service.add(entity, connId);
    }

    @PostMapping(value={"check_conflict"})
    public ConflictDetail checkConflict(@PathVariable(value="connId") int connId, @RequestBody ConflictCheckEntity entity) {
        List<PropertyKeyEntity> entities = entity.getPkEntities();
        Ex.check(!CollectionUtils.isEmpty(entities), "common.param.cannot-be-empty", "entities");
        Ex.check(CollectionUtils.isEmpty(entity.getPiEntities()), "common.param.must-be-null", "propertyindexes");
        Ex.check(CollectionUtils.isEmpty(entity.getVlEntities()), "common.param.must-be-null", "vertexlabels");
        Ex.check(CollectionUtils.isEmpty(entity.getElEntities()), "common.param.must-be-null", "edgelabels");
        entities.forEach(e -> this.checkParamsValid((PropertyKeyEntity)e, false));
        return this.service.checkConflict(entity, connId, false);
    }

    @PostMapping(value={"recheck_conflict"})
    public ConflictDetail recheckConflict(@PathVariable(value="connId") int connId, @RequestBody ConflictCheckEntity entity) {
        Ex.check(!CollectionUtils.isEmpty(entity.getPkEntities()), "common.param.cannot-be-empty", "propertykeys");
        Ex.check(CollectionUtils.isEmpty(entity.getPiEntities()), "common.param.must-be-null", "propertyindexes");
        Ex.check(CollectionUtils.isEmpty(entity.getVlEntities()), "common.param.must-be-null", "vertexlabels");
        Ex.check(CollectionUtils.isEmpty(entity.getElEntities()), "common.param.must-be-null", "edgelabels");
        return this.service.checkConflict(entity, connId, true);
    }

    @PostMapping(value={"reuse"})
    public void reuse(@PathVariable(value="connId") int connId, @RequestBody ConflictDetail detail) {
        Ex.check(!CollectionUtils.isEmpty(detail.getPkConflicts()), "common.param.cannot-be-empty", "propertykey_conflicts");
        this.service.reuse(detail, connId);
    }

    @PostMapping(value={"check_using"})
    public Map<String, Boolean> checkUsing(@PathVariable(value="connId") int connId, @RequestBody UsingCheckEntity entity) {
        Ex.check(!CollectionUtils.isEmpty(entity.getNames()), "common.param.cannot-be-empty", "names");
        LinkedHashMap<String, Boolean> inUsing = new LinkedHashMap<String, Boolean>();
        for (String name : entity.getNames()) {
            this.service.checkExist(name, connId);
            inUsing.put(name, this.service.checkUsing(name, connId));
        }
        return inUsing;
    }

    @DeleteMapping
    public void delete(@PathVariable(value="connId") int connId, @RequestParam List<String> names, @RequestParam(name="skip_using", defaultValue="false") boolean skipUsing) {
        for (String name : names) {
            this.service.checkExist(name, connId);
            if (this.service.checkUsing(name, connId)) {
                if (skipUsing) continue;
                throw new ExternalException("schema.propertykey.in-using", name);
            }
            this.service.remove(name, connId);
        }
    }

    private void checkParamsValid(PropertyKeyEntity entity, boolean checkCreateTime) {
        String name = entity.getName();
        Ex.check(name != null, "common.param.cannot-be-null", "name");
        Ex.check(Constant.SCHEMA_NAME_PATTERN.matcher(name).matches(), "schema.propertykey.unmatch-regex", new Object[0]);
        Ex.check(entity.getDataType() != null, "common.param.cannot-be-null", "data_type");
        Ex.check(entity.getCardinality() != null, "common.param.cannot-be-null", "cardinality");
        Ex.check(checkCreateTime, () -> entity.getCreateTime() == null, "common.param.must-be-null", "create_time");
    }

    private void checkEntityUnique(PropertyKeyEntity newEntity, int connId) {
        String name = newEntity.getName();
        this.service.checkNotExist(name, connId);
    }
}

