/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecrdt.service;

import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Parser;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.subjects.Subject;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.bifromq.basecluster.IAgentHost;
import org.apache.bifromq.basecluster.agent.proto.AgentMemberAddr;
import org.apache.bifromq.basecluster.memberlist.agent.IAgent;
import org.apache.bifromq.basecluster.memberlist.agent.IAgentMember;
import org.apache.bifromq.basecrdt.core.api.ICRDTOperation;
import org.apache.bifromq.basecrdt.core.api.ICausalCRDT;
import org.apache.bifromq.basecrdt.proto.Replica;
import org.apache.bifromq.basecrdt.service.AgentUtil;
import org.apache.bifromq.basecrdt.store.ICRDTStore;
import org.apache.bifromq.basecrdt.store.ReplicaIdGenerator;
import org.apache.bifromq.basecrdt.store.proto.CRDTStoreMessage;
import org.apache.bifromq.basecrdt.util.Formatter;
import org.apache.bifromq.baseenv.ZeroCopyParser;
import org.apache.bifromq.logger.MDCLogger;
import org.slf4j.Logger;

class CRDTCluster<O extends ICRDTOperation, C extends ICausalCRDT<O>> {
    private final Logger log;
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    private final IAgentHost agentHost;
    private final AgentMemberAddr endpoint;
    private final ReadWriteLock shutdownLock = new ReentrantReadWriteLock();
    private final Replica replicaId;
    private final C crdt;
    private final ICRDTStore store;
    private final IAgent membershipAgent;
    private final IAgentMember localMembership;
    private final Subject<CRDTStoreMessage> storeMsgSubject;
    private final CompositeDisposable disposables = new CompositeDisposable();
    private final CompletableFuture<Void> quitSignal = new CompletableFuture();

    CRDTCluster(String uri, ICRDTStore store, IAgentHost agentHost, Scheduler scheduler, Subject<CRDTStoreMessage> storeMsgSubject) {
        this.store = store;
        this.agentHost = agentHost;
        this.replicaId = ReplicaIdGenerator.generate((String)uri);
        this.log = MDCLogger.getLogger(CRDTCluster.class, (String[])new String[]{"store", store.id(), "replica", Formatter.print((Replica)this.replicaId)});
        this.membershipAgent = agentHost.host(this.replicaId.getUri());
        this.endpoint = AgentMemberAddr.newBuilder().setName(AgentUtil.toAgentMemberName(this.replicaId)).setEndpoint(this.membershipAgent.local().getEndpoint()).setIncarnation(this.membershipAgent.local().getIncarnation()).build();
        this.localMembership = this.membershipAgent.register(this.endpoint.getName());
        this.storeMsgSubject = storeMsgSubject;
        this.crdt = store.host(this.replicaId, this.endpoint.toByteString());
        this.disposables.add(this.membershipAgent.membership().observeOn(scheduler).subscribe(this.withLock(this.shutdownLock.readLock(), agentMembers -> {
            if (this.stopped.get()) {
                return;
            }
            Set peers = agentMembers.keySet().stream().map(AbstractMessageLite::toByteString).collect(Collectors.toSet());
            store.join(this.replicaId, peers);
        })));
        this.disposables.add(this.localMembership.receive().observeOn(scheduler).subscribe(this.withLock(this.shutdownLock.readLock(), agentMessage -> {
            if (this.stopped.get()) {
                return;
            }
            try {
                this.storeMsgSubject.onNext((Object)((CRDTStoreMessage)ZeroCopyParser.parse((ByteString)agentMessage.getPayload(), (Parser)CRDTStoreMessage.parser())));
            }
            catch (InvalidProtocolBufferException e) {
                this.log.error("Unable to parse crdt store message from agent message", (Throwable)e);
            }
        })));
        this.disposables.add(store.storeMessages().filter(msg -> msg.getSender().equals((Object)this.endpoint.toByteString())).observeOn(scheduler).subscribe(this.withLock(this.shutdownLock.readLock(), msg -> {
            if (this.stopped.get()) {
                return;
            }
            AgentMemberAddr target = (AgentMemberAddr)ZeroCopyParser.parse((ByteString)msg.getReceiver(), (Parser)AgentMemberAddr.parser());
            this.localMembership.send(target, msg.toByteString(), true).whenComplete((v, e) -> {
                if (e != null) {
                    this.log.debug("Failed to send store message, uri={}, sender={}, receiver={}", new Object[]{msg.getUri(), target.getName(), this.endpoint.getName(), e});
                } else if (this.log.isTraceEnabled()) {
                    this.log.trace("Sent store message, uri={}, sender={}, receiver={}, msg={}", new Object[]{msg.getUri(), target.getName(), this.endpoint.getName(), Formatter.toPrintable((CRDTStoreMessage)msg)});
                }
            });
        })));
    }

    C crdt() {
        return this.crdt;
    }

    Observable<Set<Replica>> aliveReplicas() {
        return this.membershipAgent.membership().map(agentMembers -> agentMembers.keySet().stream().map(agentMemberAddr -> AgentUtil.toReplica(agentMemberAddr.getName())).collect(Collectors.toSet()));
    }

    CompletableFuture<Void> close() {
        Lock lock = this.shutdownLock.writeLock();
        try {
            lock.lock();
            if (this.stopped.compareAndSet(false, true)) {
                this.disposables.dispose();
                ((CompletableFuture)((CompletableFuture)this.membershipAgent.deregister(this.localMembership).thenCompose(v -> this.store.stopHosting(this.replicaId))).thenCompose(v -> this.agentHost.stopHosting(this.replicaId.getUri()))).whenComplete((v, e) -> {
                    if (e != null) {
                        this.log.warn("Error during close", e);
                    }
                    this.quitSignal.complete(null);
                });
            }
            CompletableFuture<Void> completableFuture = this.quitSignal;
            return completableFuture;
        }
        finally {
            lock.unlock();
        }
    }

    private <T> Consumer<T> withLock(Lock lock, Consumer<T> consumer) {
        return value -> {
            try {
                lock.lock();
                consumer.accept(value);
            }
            finally {
                lock.unlock();
            }
        };
    }
}

