/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.rpc;

import org.apache.ignite3.raft.jraft.RaftMessagesFactory;
import org.apache.ignite3.raft.jraft.Status;
import org.apache.ignite3.raft.jraft.error.RaftError;
import org.apache.ignite3.raft.jraft.rpc.ErrorResponseBuilder;
import org.apache.ignite3.raft.jraft.rpc.Message;
import org.apache.ignite3.raft.jraft.rpc.RpcRequests;

public interface RpcResponseFactory {
    public static final int ERROR_RESPONSE_NUM = 99;

    default public Message newResponse(RaftMessagesFactory msgFactory, Status st) {
        if (st == null) {
            return this.newResponse(msgFactory, 0, "OK", new Object[0]);
        }
        return this.newResponse(msgFactory, st.getCode(), st.getErrorMsg(), new Object[0]);
    }

    default public Message newResponse(RaftMessagesFactory msgFactory, RaftError error, String fmt, Object ... args) {
        return this.newResponse(msgFactory, error.getNumber(), fmt, args);
    }

    default public Message newResponse(RaftMessagesFactory msgFactory, int code, String fmt, Object ... args) {
        ErrorResponseBuilder eBuilder = msgFactory.errorResponse();
        eBuilder.errorCode(code);
        if (fmt != null) {
            eBuilder.errorMsg(String.format(fmt, args));
        }
        return eBuilder.build();
    }

    default public RpcRequests.ErrorResponse newResponse(String leaderId, RaftMessagesFactory msgFactory, RaftError error, String fmt, Object ... args) {
        ErrorResponseBuilder eBuilder = msgFactory.errorResponse();
        eBuilder.errorCode(error.getNumber());
        eBuilder.leaderId(leaderId);
        if (fmt != null) {
            eBuilder.errorMsg(String.format(fmt, args));
        }
        return eBuilder.build();
    }
}

