/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table.distributed.raft.snapshot;

import org.apache.ignite3.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite3.internal.tostring.S;

final class ReadOnlyIndexInfo {
    private final int tableId;
    private final long activationTs;
    private final int indexId;
    private final int indexRemovalCatalogVersion;

    ReadOnlyIndexInfo(CatalogIndexDescriptor index, long activationTs, int indexRemovalCatalogVersion) {
        this(index.tableId(), activationTs, index.id(), indexRemovalCatalogVersion);
    }

    ReadOnlyIndexInfo(int tableId, long activationTs, int indexId, int indexRemovalCatalogVersion) {
        this.tableId = tableId;
        this.activationTs = activationTs;
        this.indexId = indexId;
        this.indexRemovalCatalogVersion = indexRemovalCatalogVersion;
    }

    int tableId() {
        return this.tableId;
    }

    long activationTs() {
        return this.activationTs;
    }

    int indexId() {
        return this.indexId;
    }

    int indexRemovalCatalogVersion() {
        return this.indexRemovalCatalogVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReadOnlyIndexInfo other = (ReadOnlyIndexInfo)o;
        return this.tableId == other.tableId && this.activationTs == other.activationTs && this.indexId == other.indexId;
    }

    public int hashCode() {
        int result = this.tableId;
        result = 31 * result + (int)(this.activationTs ^ this.activationTs >>> 32);
        result = 31 * result + this.indexId;
        return result;
    }

    public String toString() {
        return S.toString(this);
    }
}

