/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.rel;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.Util;
import org.apache.ignite3.internal.sql.engine.metadata.cost.IgniteCostFactory;
import org.apache.ignite3.internal.sql.engine.rel.IgniteConvention;
import org.apache.ignite3.internal.sql.engine.rel.IgniteLimit;
import org.apache.ignite3.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite3.internal.sql.engine.rel.IgniteRelVisitor;
import org.apache.ignite3.internal.sql.engine.rel.explain.IgniteRelWriter;
import org.apache.ignite3.internal.sql.engine.trait.IgniteDistributions;
import org.apache.ignite3.internal.sql.engine.trait.TraitUtils;
import org.apache.ignite3.internal.sql.engine.util.RexUtils;
import org.jetbrains.annotations.Nullable;

public class IgniteSort
extends Sort
implements IgniteRel {
    private static final String REL_TYPE_NAME = "Sort";

    public IgniteSort(RelOptCluster cluster, RelTraitSet traits, RelNode child, RelCollation collation, @Nullable RexNode offset, @Nullable RexNode fetch) {
        super(cluster, traits, child, collation, offset, fetch);
    }

    public IgniteSort(RelOptCluster cluster, RelTraitSet traits, RelNode child, RelCollation collation) {
        this(cluster, traits, child, collation, null, null);
    }

    public IgniteSort(RelInput input) {
        super(TraitUtils.changeTraits(input, new RelTrait[]{IgniteConvention.INSTANCE}));
    }

    public Sort copy(RelTraitSet traitSet, RelNode newInput, RelCollation newCollation, @Nullable RexNode offset, @Nullable RexNode fetch) {
        return new IgniteSort(this.getCluster(), traitSet, newInput, traitSet.getCollation(), offset, fetch);
    }

    @Override
    public <T> T accept(IgniteRelVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public RelCollation collation() {
        return this.collation;
    }

    public double estimateRowCount(RelMetadataQuery mq) {
        return IgniteLimit.estimateRowCount(mq.getRowCount(this.getInput()), this.offset, this.fetch);
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double inputRows = mq.getRowCount(this.getInput());
        double memRows = this.memRows(inputRows);
        double cpuCost = inputRows * 1.0 + Util.nLogM((double)inputRows, (double)memRows) * 3.0;
        double memory = memRows * (double)this.getRowType().getFieldCount() * 4.0;
        IgniteCostFactory costFactory = (IgniteCostFactory)planner.getCostFactory();
        RelOptCost cost = costFactory.makeCost(inputRows, cpuCost, 0.0, memory, 0.0);
        if (TraitUtils.distributionEnabled((RelNode)this) && TraitUtils.distribution(this.traitSet).satisfies((RelTrait)IgniteDistributions.single())) {
            cost = cost.plus(costFactory.makeTinyCost());
        }
        return cost;
    }

    @Override
    public IgniteRel clone(RelOptCluster cluster, List<IgniteRel> inputs) {
        return new IgniteSort(cluster, this.getTraitSet(), (RelNode)IgniteSort.sole(inputs), this.collation, this.offset, this.fetch);
    }

    private double memRows(double inputRows) {
        double fetch = this.fetch != null ? RexUtils.doubleFromRex(this.fetch, inputRows * 0.01) : inputRows;
        double offset = this.offset != null ? RexUtils.doubleFromRex(this.offset, inputRows * 0.5) : 0.0;
        return Math.min(inputRows, fetch + offset);
    }

    public String getRelTypeName() {
        return REL_TYPE_NAME;
    }

    @Override
    public IgniteRelWriter explain(IgniteRelWriter writer) {
        if (this.offset != null) {
            writer.addOffset(this.offset);
        }
        if (this.fetch != null) {
            writer.addFetch(this.fetch);
        }
        return writer.addCollation(this.collation, this.getRowType());
    }
}

