/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.ignite3.internal.failure.FailureContext;
import org.apache.ignite3.internal.failure.FailureManager;
import org.apache.ignite3.internal.failure.FailureType;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.metrics.MetricManager;
import org.apache.ignite3.internal.metrics.sources.StripedThreadPoolMetricSource;
import org.apache.ignite3.internal.sql.engine.exec.QueryTaskExecutor;
import org.apache.ignite3.internal.thread.IgniteThreadFactory;
import org.apache.ignite3.internal.thread.StripedThreadPoolExecutor;
import org.apache.ignite3.internal.thread.ThreadOperation;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.lang.IgniteException;
import org.jetbrains.annotations.TestOnly;

public class QueryTaskExecutorImpl
implements QueryTaskExecutor {
    private static final IgniteLogger LOG = Loggers.forClass(QueryTaskExecutorImpl.class);
    private static final UUID QUERY_ID_STUB = UUID.randomUUID();
    private static final String QUERY_EXECUTOR_SOURCE_NAME = "thread.pools.sql-executor";
    private final String nodeName;
    private volatile StripedThreadPoolExecutor stripedThreadPoolExecutor;
    private final int concurrencyLevel;
    private final FailureManager failureManager;
    private final MetricManager metricManager;

    public QueryTaskExecutorImpl(String nodeName, int concurrencyLevel, FailureManager failureManager, MetricManager metricManager) {
        this.nodeName = nodeName;
        this.concurrencyLevel = concurrencyLevel;
        this.failureManager = failureManager;
        this.metricManager = metricManager;
    }

    @Override
    public void start() {
        this.stripedThreadPoolExecutor = new StripedThreadPoolExecutor(this.concurrencyLevel, IgniteThreadFactory.create(this.nodeName, "sql-execution-pool", LOG, ThreadOperation.NOTHING_ALLOWED), false, 0L);
        this.metricManager.registerSource(new StripedThreadPoolMetricSource(QUERY_EXECUTOR_SOURCE_NAME, null, this.stripedThreadPoolExecutor));
        this.metricManager.enable(QUERY_EXECUTOR_SOURCE_NAME);
    }

    @Override
    public void execute(UUID qryId, long fragmentId, Runnable qryTask) {
        int commandIdx = QueryTaskExecutorImpl.hash(qryId, fragmentId);
        this.stripedThreadPoolExecutor.execute(() -> {
            try {
                qryTask.run();
            }
            catch (Throwable e) {
                String message = String.format("Unexpected error during execute fragment %d of query %s", fragmentId, qryId);
                this.failureManager.process(new FailureContext(FailureType.CRITICAL_ERROR, new IgniteException(ErrorGroups.Common.INTERNAL_ERR, message, e)));
            }
        }, commandIdx);
    }

    @Override
    public void execute(Runnable command) {
        this.execute(QUERY_ID_STUB, ThreadLocalRandom.current().nextLong(1024L), command);
    }

    @Override
    public CompletableFuture<?> submit(UUID qryId, long fragmentId, Runnable qryTask) {
        return this.stripedThreadPoolExecutor.submit(qryTask, QueryTaskExecutorImpl.hash(qryId, fragmentId));
    }

    private static int hash(UUID qryId, long fragmentId) {
        return IgniteUtils.safeAbs(31 * (31 + (qryId != null ? qryId.hashCode() : 0)) + Long.hashCode(fragmentId));
    }

    @Override
    public void stop() {
        if (this.stripedThreadPoolExecutor != null) {
            this.stripedThreadPoolExecutor.shutdownNow();
            this.metricManager.unregisterSource(QUERY_EXECUTOR_SOURCE_NAME);
        }
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.stripedThreadPoolExecutor.awaitTermination(timeout, unit);
    }

    @TestOnly
    public int queueSize() {
        int totalQueueSize = 0;
        for (int i = 0; i < this.concurrencyLevel; ++i) {
            totalQueueSize += ((ThreadPoolExecutor)this.stripedThreadPoolExecutor.stripeExecutor(i)).getQueue().size();
        }
        return totalQueueSize;
    }
}

