/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.network.replication;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.partition.replicator.network.replication.BinaryRowMessage;
import org.apache.ignite3.internal.partition.replicator.network.replication.BinaryRowMessageBuilder;
import org.apache.ignite3.internal.partition.replicator.network.replication.BinaryRowMessageSerializer;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;

public class BinaryRowMessageImpl
implements BinaryRowMessage,
Cloneable {
    public static final short GROUP_TYPE = 9;
    public static final short TYPE = 18;
    @IgniteToStringInclude
    private final ByteBuffer binaryTuple;
    @IgniteToStringInclude
    private final int schemaVersion;

    private BinaryRowMessageImpl(ByteBuffer binaryTuple, int schemaVersion) {
        this.binaryTuple = binaryTuple;
        this.schemaVersion = schemaVersion;
    }

    @Override
    public ByteBuffer binaryTuple() {
        return this.binaryTuple;
    }

    @Override
    public int schemaVersion() {
        return this.schemaVersion;
    }

    public MessageSerializer serializer() {
        return BinaryRowMessageSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 9;
    }

    public String toString() {
        return S.toString(BinaryRowMessageImpl.class, this);
    }

    @Override
    public short messageType() {
        return 18;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        BinaryRowMessageImpl otherMessage = (BinaryRowMessageImpl)other;
        return Objects.equals(this.binaryTuple, otherMessage.binaryTuple) && this.schemaVersion == otherMessage.schemaVersion;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.schemaVersion, this.binaryTuple);
        return result;
    }

    @Override
    public BinaryRowMessageImpl clone() {
        try {
            return (BinaryRowMessageImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static BinaryRowMessageBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements BinaryRowMessageBuilder {
        private ByteBuffer binaryTuple;
        private int schemaVersion;

        private Builder() {
        }

        @Override
        public BinaryRowMessageBuilder binaryTuple(ByteBuffer binaryTuple) {
            Objects.requireNonNull(binaryTuple, "binaryTuple is not marked @Nullable");
            this.binaryTuple = binaryTuple;
            return this;
        }

        @Override
        public BinaryRowMessageBuilder schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @Override
        public ByteBuffer binaryTuple() {
            return this.binaryTuple;
        }

        @Override
        public int schemaVersion() {
            return this.schemaVersion;
        }

        @Override
        public BinaryRowMessage build() {
            return new BinaryRowMessageImpl(Objects.requireNonNull(this.binaryTuple, "binaryTuple is not marked @Nullable"), this.schemaVersion);
        }
    }
}

