/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.call.node.metric;

import jakarta.inject.Singleton;
import java.util.List;
import org.apache.ignite3.internal.cli.core.call.Call;
import org.apache.ignite3.internal.cli.core.call.CallOutput;
import org.apache.ignite3.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite3.internal.cli.core.call.UrlCallInput;
import org.apache.ignite3.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite3.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite3.rest.client.api.NodeMetricApi;
import org.apache.ignite3.rest.client.invoker.ApiException;
import org.apache.ignite3.rest.client.model.MetricSource;

@Singleton
public class NodeMetricSourceListCall
implements Call<UrlCallInput, List<MetricSource>> {
    private final ApiClientFactory clientFactory;

    public NodeMetricSourceListCall(ApiClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    @Override
    public CallOutput<List<MetricSource>> execute(UrlCallInput input) {
        try {
            return DefaultCallOutput.success(this.listNodeMetricSources(input));
        }
        catch (IllegalArgumentException | ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, input.getUrl()));
        }
    }

    private List<MetricSource> listNodeMetricSources(UrlCallInput input) throws ApiException {
        return new NodeMetricApi(this.clientFactory.getClient(input.getUrl())).listNodeMetricSources();
    }
}

