/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.optimizer.affinity;

import java.util.Collection;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionAllNode;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionNode;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionNoneNode;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionTableAffinityDescriptor;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;

public class PartitionResult {
    @GridToStringInclude
    private final PartitionNode tree;
    private final PartitionTableAffinityDescriptor aff;
    private final AffinityTopologyVersion topVer;
    private final String cacheName;
    private final int partsCnt;

    public PartitionResult(PartitionNode tree, PartitionTableAffinityDescriptor aff, AffinityTopologyVersion topVer) {
        this.tree = tree;
        this.aff = aff;
        this.topVer = topVer;
        this.cacheName = tree != null ? tree.cacheName() : null;
        this.partsCnt = aff != null ? aff.parts() : 0;
    }

    public PartitionResult(PartitionNode tree, AffinityTopologyVersion topVer, String cacheName, int partsCnt) {
        this.tree = tree;
        this.aff = null;
        this.topVer = topVer;
        this.cacheName = cacheName;
        this.partsCnt = partsCnt;
    }

    public PartitionNode tree() {
        return this.tree;
    }

    public PartitionTableAffinityDescriptor affinity() {
        return this.aff;
    }

    public static int[] calculatePartitions(int[] explicitParts, PartitionResult derivedParts, Object[] args) {
        if (!F.isEmpty(explicitParts)) {
            return explicitParts;
        }
        if (derivedParts != null) {
            try {
                Collection<Integer> realParts = derivedParts.tree().apply(null, args);
                if (realParts == null) {
                    return null;
                }
                if (realParts.isEmpty()) {
                    return IgniteUtils.EMPTY_INTS;
                }
                int[] realParts0 = new int[realParts.size()];
                int i = 0;
                for (Integer realPart : realParts) {
                    realParts0[i++] = realPart;
                }
                return realParts0;
            }
            catch (IgniteCheckedException e) {
                throw new CacheException("Failed to calculate derived partitions for query.", (Throwable)e);
            }
        }
        return null;
    }

    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    public String cacheName() {
        return this.cacheName;
    }

    public int partitionsCount() {
        return this.partsCnt;
    }

    public boolean isClientPartitionAwarenessApplicable() {
        return this.aff != null && this.aff.isClientPartitionAwarenessApplicable() && !(this.tree instanceof PartitionNoneNode) && !(this.tree instanceof PartitionAllNode);
    }

    public String toString() {
        return S.toString(PartitionResult.class, this);
    }
}

