/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.odbc.ClientListenerAbstractConnectionContext;
import org.apache.ignite.internal.processors.platform.client.tx.ClientTxContext;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;

public interface ClientTxSupport {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public int startClientTransaction(ClientListenerAbstractConnectionContext ctx, TransactionConcurrency concurrency, TransactionIsolation isolation, long timeout, String lb) {
        GridNearTxLocal tx;
        ctx.kernalContext().gateway().readLock();
        try {
            tx = ctx.kernalContext().cache().context().tm().newTx(false, false, null, concurrency, isolation, timeout, true, 0, lb);
        }
        finally {
            ctx.kernalContext().gateway().readUnlock();
        }
        try {
            tx.suspend();
            int txId = ctx.nextTxId();
            ctx.addTxContext(new ClientTxContext(txId, tx));
            return txId;
        }
        catch (Exception e) {
            try {
                tx.close();
            }
            catch (Exception e1) {
                e.addSuppressed(e1);
            }
            throw this.startTxException(e);
        }
    }

    default public IgniteInternalFuture<IgniteInternalTx> endTxAsync(ClientListenerAbstractConnectionContext ctx, int txId, boolean committed) {
        ClientTxContext txCtx = ctx.txContext(txId);
        if (txCtx == null && !committed) {
            return new GridFinishedFuture<IgniteInternalTx>();
        }
        if (txCtx == null) {
            throw this.transactionNotFoundException();
        }
        try {
            txCtx.acquire(committed);
            if (committed) {
                IgniteInternalFuture<IgniteInternalTx> igniteInternalFuture = txCtx.tx().context().commitTxAsync(txCtx.tx());
                return igniteInternalFuture;
            }
            IgniteInternalFuture<IgniteInternalTx> igniteInternalFuture = txCtx.tx().rollbackAsync();
            return igniteInternalFuture;
        }
        catch (IgniteCheckedException e) {
            throw this.endTxException(e);
        }
        finally {
            ctx.removeTxContext(txId);
            try {
                txCtx.release(false);
            }
            catch (IgniteCheckedException igniteCheckedException) {}
        }
    }

    default public RuntimeException startTxException(Exception cause) {
        return new UnsupportedOperationException();
    }

    default public RuntimeException endTxException(IgniteCheckedException cause) {
        return new UnsupportedOperationException();
    }

    default public RuntimeException transactionNotFoundException() {
        return new UnsupportedOperationException();
    }
}

