/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management;

import java.util.function.Consumer;
import org.apache.ignite.internal.management.ChangeTagCommandArg;
import org.apache.ignite.internal.management.ClusterChangeTagTask;
import org.apache.ignite.internal.management.ClusterChangeTagTaskResult;
import org.apache.ignite.internal.management.api.ComputeCommand;

public class ChangeTagCommand
implements ComputeCommand<ChangeTagCommandArg, ClusterChangeTagTaskResult> {
    @Override
    public String description() {
        return "Change cluster tag to new value";
    }

    @Override
    public Class<ChangeTagCommandArg> argClass() {
        return ChangeTagCommandArg.class;
    }

    @Override
    public Class<ClusterChangeTagTask> taskClass() {
        return ClusterChangeTagTask.class;
    }

    @Override
    public void printResult(ChangeTagCommandArg arg, ClusterChangeTagTaskResult res, Consumer<String> printer) {
        if (res.success().booleanValue()) {
            printer.accept("Cluster tag updated successfully, old tag was: " + res.tag());
        } else {
            printer.accept("Error has occurred during tag update: " + res.errorMessage());
        }
    }

    @Override
    public String confirmationPrompt(ChangeTagCommandArg arg) {
        return "Warning: the command will change cluster tag.";
    }
}

