/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted.keys;

import java.math.BigDecimal;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.NumericIndexKey;

public class BooleanIndexKey
extends NumericIndexKey {
    private final boolean key;

    public BooleanIndexKey(boolean key) {
        this.key = key;
    }

    @Override
    public Object key() {
        return this.key;
    }

    @Override
    public IndexKeyType type() {
        return IndexKeyType.BOOLEAN;
    }

    @Override
    public int compareTo(boolean val) {
        return Boolean.compare(this.key, val);
    }

    @Override
    public int compareTo(byte val) {
        return Boolean.compare(this.key, val != 0);
    }

    @Override
    public int compareTo(short val) {
        return Boolean.compare(this.key, val != 0);
    }

    @Override
    public int compareTo(int val) {
        return Boolean.compare(this.key, val != 0);
    }

    @Override
    public int compareTo(long val) {
        return Boolean.compare(this.key, val != 0L);
    }

    @Override
    public int compareTo(float val) {
        return Boolean.compare(this.key, val != 0.0f);
    }

    @Override
    public int compareTo(double val) {
        return Boolean.compare(this.key, val != 0.0);
    }

    @Override
    public int compareTo(BigDecimal val) {
        return Boolean.compare(this.key, val.compareTo(BigDecimal.ZERO) != 0);
    }

    @Override
    public int compare(IndexKey o) {
        return -((NumericIndexKey)o).compareTo(this.key);
    }

    public String toString() {
        return String.valueOf(this.key);
    }
}

