/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.dsl;

import java.nio.ByteBuffer;
import org.apache.ignite.internal.lang.ByteArray;
import org.apache.ignite.internal.metastorage.dsl.CompoundCondition;
import org.apache.ignite.internal.metastorage.dsl.CompoundConditionType;
import org.apache.ignite.internal.metastorage.dsl.Condition;
import org.apache.ignite.internal.metastorage.dsl.ConditionType;
import org.apache.ignite.internal.metastorage.dsl.MetaStorageMessagesFactory;
import org.apache.ignite.internal.metastorage.dsl.SimpleCondition;

public final class Conditions {
    private static final MetaStorageMessagesFactory MSG_FACTORY = new MetaStorageMessagesFactory();

    public static ValueConditionBuilder value(ByteArray key) {
        return new ValueConditionBuilder(key.bytes());
    }

    public static SimpleCondition tombstone(ByteArray key) {
        return MSG_FACTORY.simpleCondition().key(ByteBuffer.wrap(key.bytes())).type(ConditionType.TOMBSTONE).build();
    }

    public static SimpleCondition notTombstone(ByteArray key) {
        return MSG_FACTORY.simpleCondition().key(ByteBuffer.wrap(key.bytes())).type(ConditionType.NOT_TOMBSTONE).build();
    }

    public static SimpleCondition exists(ByteArray key) {
        return MSG_FACTORY.simpleCondition().key(ByteBuffer.wrap(key.bytes())).type(ConditionType.KEY_EXISTS).build();
    }

    public static SimpleCondition notExists(ByteArray key) {
        return MSG_FACTORY.simpleCondition().key(ByteBuffer.wrap(key.bytes())).type(ConditionType.KEY_NOT_EXISTS).build();
    }

    public static RevisionConditionBuilder revision(ByteArray key) {
        return new RevisionConditionBuilder(key.bytes());
    }

    public static CompoundCondition and(Condition leftCond, Condition rightCond) {
        return MSG_FACTORY.compoundCondition().leftCondition(leftCond).rightCondition(rightCond).type(CompoundConditionType.AND).build();
    }

    public static CompoundCondition or(Condition leftCond, Condition rightCond) {
        return MSG_FACTORY.compoundCondition().leftCondition(leftCond).rightCondition(rightCond).type(CompoundConditionType.OR).build();
    }

    private Conditions() {
    }

    public static final class ValueConditionBuilder {
        private final byte[] key;

        ValueConditionBuilder(byte[] key) {
            this.key = key;
        }

        public SimpleCondition eq(byte[] val) {
            return MSG_FACTORY.valueCondition().key(ByteBuffer.wrap(this.key)).type(ConditionType.VAL_EQUAL).value(ByteBuffer.wrap(val)).build();
        }

        public SimpleCondition ne(byte[] val) {
            return MSG_FACTORY.valueCondition().key(ByteBuffer.wrap(this.key)).type(ConditionType.VAL_NOT_EQUAL).value(ByteBuffer.wrap(val)).build();
        }

        public SimpleCondition gt(byte[] val) {
            return MSG_FACTORY.valueCondition().key(ByteBuffer.wrap(this.key)).type(ConditionType.VAL_GREATER).value(ByteBuffer.wrap(val)).build();
        }

        public SimpleCondition ge(byte[] val) {
            return MSG_FACTORY.valueCondition().key(ByteBuffer.wrap(this.key)).type(ConditionType.VAL_GREATER_OR_EQUAL).value(ByteBuffer.wrap(val)).build();
        }

        public SimpleCondition lt(byte[] val) {
            return MSG_FACTORY.valueCondition().key(ByteBuffer.wrap(this.key)).type(ConditionType.VAL_LESS).value(ByteBuffer.wrap(val)).build();
        }

        public SimpleCondition le(byte[] val) {
            return MSG_FACTORY.valueCondition().key(ByteBuffer.wrap(this.key)).type(ConditionType.VAL_LESS_OR_EQUAL).value(ByteBuffer.wrap(val)).build();
        }
    }

    public static final class RevisionConditionBuilder {
        private final byte[] key;

        RevisionConditionBuilder(byte[] key) {
            this.key = key;
        }

        public SimpleCondition eq(long rev) {
            return MSG_FACTORY.revisionCondition().key(ByteBuffer.wrap(this.key)).type(ConditionType.REV_EQUAL).revision(rev).build();
        }

        public SimpleCondition ne(long rev) {
            return MSG_FACTORY.revisionCondition().key(ByteBuffer.wrap(this.key)).type(ConditionType.REV_NOT_EQUAL).revision(rev).build();
        }

        public SimpleCondition gt(long rev) {
            return MSG_FACTORY.revisionCondition().key(ByteBuffer.wrap(this.key)).type(ConditionType.REV_GREATER).revision(rev).build();
        }

        public SimpleCondition ge(long rev) {
            return MSG_FACTORY.revisionCondition().key(ByteBuffer.wrap(this.key)).type(ConditionType.REV_GREATER_OR_EQUAL).revision(rev).build();
        }

        public SimpleCondition lt(long rev) {
            return MSG_FACTORY.revisionCondition().key(ByteBuffer.wrap(this.key)).type(ConditionType.REV_LESS).revision(rev).build();
        }

        public SimpleCondition le(long rev) {
            return MSG_FACTORY.revisionCondition().key(ByteBuffer.wrap(this.key)).type(ConditionType.REV_LESS_OR_EQUAL).revision(rev).build();
        }
    }
}

