/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.compute.NextWorkerSelector;
import org.apache.ignite.internal.hlc.HybridClock;
import org.apache.ignite.internal.network.InternalClusterNode;
import org.apache.ignite.internal.network.TopologyService;
import org.apache.ignite.internal.placementdriver.PlacementDriver;
import org.apache.ignite.internal.placementdriver.ReplicaMeta;
import org.apache.ignite.internal.replicator.PartitionGroupId;
import org.apache.ignite.internal.replicator.ReplicationGroupId;

abstract class PrimaryReplicaNextWorkerSelector
implements NextWorkerSelector {
    private static final int PRIMARY_REPLICA_ASK_CLOCK_ADDITION_MILLIS = 10000;
    private static final int AWAIT_FOR_PRIMARY_REPLICA_SECONDS = 15;
    private final PlacementDriver placementDriver;
    private final TopologyService topologyService;
    private final HybridClock clock;

    PrimaryReplicaNextWorkerSelector(PlacementDriver placementDriver, TopologyService topologyService, HybridClock clock) {
        this.placementDriver = placementDriver;
        this.topologyService = topologyService;
        this.clock = clock;
    }

    @Override
    public CompletableFuture<InternalClusterNode> next() {
        return ((CompletableFuture)this.placementDriver.awaitPrimaryReplica((ReplicationGroupId)this.partitionGroupId(), this.clock.now().addPhysicalTime(10000L), 15L, TimeUnit.SECONDS).thenApply(ReplicaMeta::getLeaseholderId)).thenApply(arg_0 -> ((TopologyService)this.topologyService).getById(arg_0));
    }

    protected abstract PartitionGroupId partitionGroupId();
}

