/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.disaster.system;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.internal.disaster.system.message.ResetClusterMessage;
import org.apache.ignite.internal.disaster.system.message.SystemDisasterRecoveryMessagesFactory;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;
import org.apache.ignite.internal.versioned.VersionedSerializer;
import org.jetbrains.annotations.Nullable;

public class ResetClusterMessagePersistentSerializer
extends VersionedSerializer<ResetClusterMessage> {
    private static final SystemDisasterRecoveryMessagesFactory MESSAGES_FACTORY = new SystemDisasterRecoveryMessagesFactory();
    public static final ResetClusterMessagePersistentSerializer INSTANCE = new ResetClusterMessagePersistentSerializer();

    protected void writeExternalData(ResetClusterMessage message, IgniteDataOutput out) throws IOException {
        ResetClusterMessagePersistentSerializer.writeStringSet((Set)message.newCmgNodes(), (IgniteDataOutput)out);
        ResetClusterMessagePersistentSerializer.writeStringSet((Set)message.currentMetaStorageNodes(), (IgniteDataOutput)out);
        out.writeUTF(message.clusterName());
        out.writeUuid(message.clusterId());
        ResetClusterMessagePersistentSerializer.writeNullableString((String)message.initialClusterConfiguration(), (IgniteDataOutput)out);
        out.writeVarInt((long)message.formerClusterIds().size());
        for (UUID id : message.formerClusterIds()) {
            out.writeUuid(id);
        }
        Integer metastorageReplicationFactor = message.metastorageReplicationFactor();
        out.writeVarInt(metastorageReplicationFactor == null ? -1L : (long)metastorageReplicationFactor.intValue());
        ResetClusterMessagePersistentSerializer.writeNullableString((String)message.conductor(), (IgniteDataOutput)out);
        Set participatingNodes = message.participatingNodes();
        if (participatingNodes == null) {
            out.writeVarInt(-1L);
        } else {
            ResetClusterMessagePersistentSerializer.writeStringSet((Set)participatingNodes, (IgniteDataOutput)out);
        }
    }

    protected ResetClusterMessage readExternalData(byte protoVer, IgniteDataInput in) throws IOException {
        Set newCmgNodes = ResetClusterMessagePersistentSerializer.readStringSet((IgniteDataInput)in);
        Set currentMetaStorageNodes = ResetClusterMessagePersistentSerializer.readStringSet((IgniteDataInput)in);
        String clusterName = in.readUTF();
        UUID clusterId = in.readUuid();
        String initialClusterConfiguration = ResetClusterMessagePersistentSerializer.readNullableString((IgniteDataInput)in);
        List<UUID> formerClusterIds = ResetClusterMessagePersistentSerializer.readFormerClusterIds(in);
        Integer metastorageReplicationFactor = ResetClusterMessagePersistentSerializer.readNullableInteger(in);
        String conductor = ResetClusterMessagePersistentSerializer.readNullableString((IgniteDataInput)in);
        Set<String> participatingNodes = ResetClusterMessagePersistentSerializer.readNullableStringSet(in);
        return MESSAGES_FACTORY.resetClusterMessage().newCmgNodes(newCmgNodes).currentMetaStorageNodes(currentMetaStorageNodes).clusterName(clusterName).clusterId(clusterId).initialClusterConfiguration(initialClusterConfiguration).formerClusterIds(formerClusterIds).metastorageReplicationFactor(metastorageReplicationFactor).conductor(conductor).participatingNodes(participatingNodes).build();
    }

    private static Set<String> readStringSet(int size, IgniteDataInput in) throws IOException {
        HashSet<String> result = new HashSet<String>(size);
        for (int i = 0; i < size; ++i) {
            result.add(in.readUTF());
        }
        return result;
    }

    private static List<UUID> readFormerClusterIds(IgniteDataInput in) throws IOException {
        int length = in.readVarIntAsInt();
        assert (length >= 0) : length;
        ArrayList<UUID> result = new ArrayList<UUID>(length);
        for (int i = 0; i < length; ++i) {
            result.add(in.readUuid());
        }
        return result;
    }

    @Nullable
    private static Integer readNullableInteger(IgniteDataInput in) throws IOException {
        int val = in.readVarIntAsInt();
        return val == -1 ? null : Integer.valueOf(val);
    }

    @Nullable
    private static Set<String> readNullableStringSet(IgniteDataInput in) throws IOException {
        int lengthOrMinusOne = in.readVarIntAsInt();
        if (lengthOrMinusOne == -1) {
            return null;
        }
        return ResetClusterMessagePersistentSerializer.readStringSet(lengthOrMinusOne, in);
    }
}

