/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.disaster.system;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.cluster.management.ClusterIdStore;
import org.apache.ignite.internal.cluster.management.ClusterState;
import org.apache.ignite.internal.disaster.system.SystemDisasterRecoveryStorage;
import org.apache.ignite.internal.disaster.system.message.ResetClusterMessage;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.manager.IgniteComponent;
import org.apache.ignite.internal.network.ClusterIdSupplier;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.vault.VaultManager;
import org.jetbrains.annotations.Nullable;

public class ClusterIdService
implements ClusterIdSupplier,
ClusterIdStore,
IgniteComponent {
    private final SystemDisasterRecoveryStorage storage;
    @Nullable
    private volatile UUID clusterId;
    @Nullable
    private volatile UUID clusterIdOverride;

    public ClusterIdService(VaultManager vault) {
        this.storage = new SystemDisasterRecoveryStorage(vault);
    }

    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        ResetClusterMessage resetClusterMessage;
        ClusterState clusterState = this.storage.readClusterState();
        if (clusterState != null) {
            this.clusterId(clusterState.clusterTag().clusterId());
        }
        if ((resetClusterMessage = this.storage.readResetClusterMessage()) != null) {
            this.clusterIdOverride = resetClusterMessage.clusterId();
        }
        return CompletableFutures.nullCompletedFuture();
    }

    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        return CompletableFutures.nullCompletedFuture();
    }

    public UUID clusterId() {
        UUID override = this.clusterIdOverride;
        if (override != null) {
            return override;
        }
        return this.clusterId;
    }

    public void clusterId(UUID newClusterId) {
        this.clusterId = newClusterId;
    }
}

