/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.storage;

import java.io.IOException;
import org.apache.ignite.internal.catalog.storage.DropZoneEntry;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectDataInput;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectDataOutput;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogSerializer;

public class DropZoneEntrySerializers {

    @CatalogSerializer(version=2, since="3.1.0")
    static class DropZoneEntrySerializerV2
    implements CatalogObjectSerializer<DropZoneEntry> {
        DropZoneEntrySerializerV2() {
        }

        @Override
        public DropZoneEntry readFrom(CatalogObjectDataInput input) throws IOException {
            int zoneId = input.readVarIntAsInt();
            return new DropZoneEntry(zoneId);
        }

        @Override
        public void writeTo(DropZoneEntry entry, CatalogObjectDataOutput output) throws IOException {
            output.writeVarInt(entry.zoneId());
        }
    }

    @CatalogSerializer(version=1, since="3.0.0")
    static class DropZoneEntrySerializerV1
    implements CatalogObjectSerializer<DropZoneEntry> {
        DropZoneEntrySerializerV1() {
        }

        @Override
        public DropZoneEntry readFrom(CatalogObjectDataInput input) throws IOException {
            int zoneId = input.readVarIntAsInt();
            return new DropZoneEntry(zoneId);
        }

        @Override
        public void writeTo(DropZoneEntry entry, CatalogObjectDataOutput output) throws IOException {
            output.writeVarInt(entry.zoneId());
        }
    }
}

