/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.message;

import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.sql.engine.message.ErrorMessage;
import org.apache.ignite.internal.sql.engine.message.ErrorMessageBuilder;
import org.apache.ignite.internal.sql.engine.message.ErrorMessageSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class ErrorMessageImpl
implements ErrorMessage,
Cloneable {
    public static final short GROUP_TYPE = 4;
    public static final short TYPE = 2;
    @IgniteToStringInclude
    private final int code;
    @IgniteToStringInclude
    private final int executionToken;
    @IgniteToStringInclude
    private final long fragmentId;
    @IgniteToStringInclude
    private final String message;
    @IgniteToStringInclude
    private final UUID queryId;
    @IgniteToStringInclude
    private final UUID traceId;

    private ErrorMessageImpl(int code, int executionToken, long fragmentId, String message, UUID queryId, UUID traceId) {
        this.code = code;
        this.executionToken = executionToken;
        this.fragmentId = fragmentId;
        this.message = message;
        this.queryId = queryId;
        this.traceId = traceId;
    }

    @Override
    public int code() {
        return this.code;
    }

    @Override
    public int executionToken() {
        return this.executionToken;
    }

    @Override
    public long fragmentId() {
        return this.fragmentId;
    }

    @Override
    public String message() {
        return this.message;
    }

    @Override
    public UUID queryId() {
        return this.queryId;
    }

    @Override
    public UUID traceId() {
        return this.traceId;
    }

    public MessageSerializer serializer() {
        return ErrorMessageSerializer.INSTANCE;
    }

    public short groupType() {
        return 4;
    }

    public String toString() {
        return S.toString(ErrorMessageImpl.class, (Object)this);
    }

    public short messageType() {
        return 2;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ErrorMessageImpl otherMessage = (ErrorMessageImpl)other;
        return Objects.equals(this.message, otherMessage.message) && Objects.equals(this.queryId, otherMessage.queryId) && Objects.equals(this.traceId, otherMessage.traceId) && this.code == otherMessage.code && this.executionToken == otherMessage.executionToken && this.fragmentId == otherMessage.fragmentId;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.code, this.executionToken, this.fragmentId, this.message, this.queryId, this.traceId);
        return result;
    }

    public ErrorMessageImpl clone() {
        try {
            return (ErrorMessageImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static ErrorMessageBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements ErrorMessageBuilder {
        private int code;
        private int executionToken;
        private long fragmentId;
        private String message;
        private UUID queryId;
        private UUID traceId;

        private Builder() {
        }

        @Override
        public ErrorMessageBuilder code(int code) {
            this.code = code;
            return this;
        }

        @Override
        public ErrorMessageBuilder executionToken(int executionToken) {
            this.executionToken = executionToken;
            return this;
        }

        @Override
        public ErrorMessageBuilder fragmentId(long fragmentId) {
            this.fragmentId = fragmentId;
            return this;
        }

        @Override
        public ErrorMessageBuilder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public ErrorMessageBuilder queryId(UUID queryId) {
            Objects.requireNonNull(queryId, "queryId is not marked @Nullable");
            this.queryId = queryId;
            return this;
        }

        @Override
        public ErrorMessageBuilder traceId(UUID traceId) {
            Objects.requireNonNull(traceId, "traceId is not marked @Nullable");
            this.traceId = traceId;
            return this;
        }

        @Override
        public int code() {
            return this.code;
        }

        @Override
        public int executionToken() {
            return this.executionToken;
        }

        @Override
        public long fragmentId() {
            return this.fragmentId;
        }

        @Override
        public String message() {
            return this.message;
        }

        @Override
        public UUID queryId() {
            return this.queryId;
        }

        @Override
        public UUID traceId() {
            return this.traceId;
        }

        @Override
        public ErrorMessage build() {
            return new ErrorMessageImpl(this.code, this.executionToken, this.fragmentId, this.message, Objects.requireNonNull(this.queryId, "queryId is not marked @Nullable"), Objects.requireNonNull(this.traceId, "traceId is not marked @Nullable"));
        }
    }
}

