/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.compaction.message;

import java.util.BitSet;
import java.util.Objects;
import org.apache.ignite.internal.catalog.compaction.message.AvailablePartitionsMessage;
import org.apache.ignite.internal.catalog.compaction.message.AvailablePartitionsMessageBuilder;
import org.apache.ignite.internal.catalog.compaction.message.AvailablePartitionsMessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class AvailablePartitionsMessageImpl
implements AvailablePartitionsMessage,
Cloneable {
    public static final short GROUP_TYPE = 14;
    public static final short TYPE = 40;
    @IgniteToStringInclude
    private final BitSet partitions;
    @IgniteToStringInclude
    private final int tableId;

    private AvailablePartitionsMessageImpl(BitSet partitions, int tableId) {
        this.partitions = partitions;
        this.tableId = tableId;
    }

    @Override
    public BitSet partitions() {
        return this.partitions;
    }

    @Override
    public int tableId() {
        return this.tableId;
    }

    public MessageSerializer serializer() {
        return AvailablePartitionsMessageSerializer.INSTANCE;
    }

    public short groupType() {
        return 14;
    }

    public String toString() {
        return S.toString(AvailablePartitionsMessageImpl.class, (Object)this);
    }

    public short messageType() {
        return 40;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        AvailablePartitionsMessageImpl otherMessage = (AvailablePartitionsMessageImpl)other;
        return Objects.equals(this.partitions, otherMessage.partitions) && this.tableId == otherMessage.tableId;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.tableId, this.partitions);
        return result;
    }

    public AvailablePartitionsMessageImpl clone() {
        try {
            return (AvailablePartitionsMessageImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static AvailablePartitionsMessageBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements AvailablePartitionsMessageBuilder {
        private BitSet partitions;
        private int tableId;

        private Builder() {
        }

        @Override
        public AvailablePartitionsMessageBuilder partitions(BitSet partitions) {
            Objects.requireNonNull(partitions, "partitions is not marked @Nullable");
            this.partitions = partitions;
            return this;
        }

        @Override
        public AvailablePartitionsMessageBuilder tableId(int tableId) {
            this.tableId = tableId;
            return this;
        }

        @Override
        public BitSet partitions() {
            return this.partitions;
        }

        @Override
        public int tableId() {
            return this.tableId;
        }

        @Override
        public AvailablePartitionsMessage build() {
            return new AvailablePartitionsMessageImpl(Objects.requireNonNull(this.partitions, "partitions is not marked @Nullable"), this.tableId);
        }
    }
}

