/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.core.repl.registry.impl;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import jakarta.inject.Singleton;
import org.apache.ignite.internal.cli.call.configuration.ClusterConfigShowCall;
import org.apache.ignite.internal.cli.call.configuration.ClusterConfigShowCallInput;
import org.apache.ignite.internal.cli.call.configuration.JsonString;
import org.apache.ignite.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite.internal.cli.core.repl.SessionInfo;
import org.apache.ignite.internal.cli.core.repl.registry.ClusterConfigRegistry;
import org.apache.ignite.internal.cli.core.repl.registry.impl.LazyObjectRef;
import org.apache.ignite.internal.cli.event.ConnectionEventListener;
import org.jetbrains.annotations.Nullable;

@Singleton
public class ClusterConfigRegistryImpl
implements ClusterConfigRegistry,
ConnectionEventListener {
    private final ClusterConfigShowCall clusterConfigShowCall;
    @Nullable
    private LazyObjectRef<Config> configRef;

    public ClusterConfigRegistryImpl(ClusterConfigShowCall clusterConfigShowCall) {
        this.clusterConfigShowCall = clusterConfigShowCall;
    }

    @Override
    public void onConnect(SessionInfo sessionInfo) {
        this.configRef = new LazyObjectRef<Config>(() -> this.fetchConfig(sessionInfo));
    }

    @Nullable
    private Config fetchConfig(SessionInfo sessionInfo) {
        ClusterConfigShowCallInput input = ClusterConfigShowCallInput.builder().clusterUrl(sessionInfo.nodeUrl()).build();
        DefaultCallOutput<JsonString> output = this.clusterConfigShowCall.execute(input);
        if (output.hasError()) {
            return null;
        }
        return ConfigFactory.parseString((String)output.body().getValue());
    }

    @Override
    public void onDisconnect() {
        this.configRef = null;
    }

    @Override
    @Nullable
    public Config config() {
        return this.configRef == null ? null : this.configRef.get();
    }
}

