/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.core.call;

import java.io.PrintWriter;
import java.util.function.Supplier;
import org.apache.ignite.internal.cli.core.call.CallExecutionPipeline;
import org.apache.ignite.internal.cli.core.call.CallInput;
import org.apache.ignite.internal.cli.core.call.CallOutput;
import org.apache.ignite.internal.cli.core.decorator.Decorator;
import org.apache.ignite.internal.cli.core.decorator.DecoratorRegistry;
import org.apache.ignite.internal.cli.core.decorator.TerminalOutput;
import org.apache.ignite.internal.cli.core.exception.ExceptionHandlers;
import org.apache.ignite.internal.cli.core.exception.ExceptionWriter;
import org.apache.ignite.internal.cli.decorators.DefaultDecoratorRegistry;
import org.apache.ignite.internal.cli.logger.CliLoggers;

public abstract class AbstractCallExecutionPipeline<I extends CallInput, T>
implements CallExecutionPipeline<I, T> {
    protected final PrintWriter output;
    protected final PrintWriter errOutput;
    protected final Decorator<T, TerminalOutput> decorator;
    private final DecoratorRegistry decoratorRegistry = new DefaultDecoratorRegistry();
    protected final ExceptionHandlers exceptionHandlers;
    protected final Supplier<I> inputProvider;
    protected final boolean[] verbose;

    AbstractCallExecutionPipeline(PrintWriter output, PrintWriter errOutput, ExceptionHandlers exceptionHandlers, Decorator<T, TerminalOutput> decorator, Supplier<I> inputProvider, boolean[] verbose) {
        this.output = output;
        this.exceptionHandlers = exceptionHandlers;
        this.errOutput = errOutput;
        this.decorator = decorator;
        this.inputProvider = inputProvider;
        this.verbose = verbose;
    }

    @Override
    public int runPipeline() {
        try {
            if (this.verbose.length > 0) {
                CliLoggers.startOutputRedirect(this.errOutput, this.verbose);
            }
            int n = this.runPipelineInternal();
            return n;
        }
        finally {
            if (this.verbose.length > 0) {
                CliLoggers.stopOutputRedirect();
            }
        }
    }

    int handleResult(CallOutput<T> callOutput) {
        if (callOutput.hasError()) {
            return this.handleException(callOutput.errorCause());
        }
        if (!callOutput.isEmpty()) {
            TerminalOutput decoratedOutput = this.decorate(callOutput.body());
            this.output.println(decoratedOutput.toTerminalString());
        }
        return 0;
    }

    private TerminalOutput decorate(T body) {
        return this.selectDecorator(body).decorate(body);
    }

    private Decorator<T, TerminalOutput> selectDecorator(T body) {
        if (this.decorator != null) {
            return this.decorator;
        }
        return this.decoratorRegistry.getDecorator(body.getClass());
    }

    protected abstract int runPipelineInternal();

    int handleException(Throwable error) {
        return this.exceptionHandlers.handleException(ExceptionWriter.fromPrintWriter(this.errOutput), error);
    }
}

