/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.html2md.converter;

import com.vladsch.flexmark.html2md.converter.DelegatingNodeRendererFactory;
import com.vladsch.flexmark.html2md.converter.HtmlNodeRenderer;
import com.vladsch.flexmark.html2md.converter.HtmlNodeRendererFactory;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.dependency.Dependent;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

class DelegatingNodeRendererFactoryWrapper
implements Function<DataHolder, HtmlNodeRenderer>,
Dependent,
DelegatingNodeRendererFactory {
    private final HtmlNodeRendererFactory nodeRendererFactory;
    private List<DelegatingNodeRendererFactoryWrapper> nodeRenderers;
    private Set<Class<?>> myDelegates = null;

    public DelegatingNodeRendererFactoryWrapper(List<DelegatingNodeRendererFactoryWrapper> nodeRenderers, HtmlNodeRendererFactory nodeRendererFactory) {
        this.nodeRendererFactory = nodeRendererFactory;
        this.nodeRenderers = nodeRenderers;
    }

    @Override
    public HtmlNodeRenderer apply(DataHolder options) {
        return this.nodeRendererFactory.apply(options);
    }

    public HtmlNodeRendererFactory getFactory() {
        return this.nodeRendererFactory;
    }

    @Override
    public Set<Class<?>> getDelegates() {
        return this.nodeRendererFactory instanceof DelegatingNodeRendererFactory ? ((DelegatingNodeRendererFactory)this.nodeRendererFactory).getDelegates() : null;
    }

    @Nullable
    public final Set<Class<?>> getAfterDependents() {
        return null;
    }

    @Nullable
    public Set<Class<?>> getBeforeDependents() {
        if (this.myDelegates == null && this.nodeRenderers != null) {
            Set<Class<?>> delegates = this.getDelegates();
            if (delegates != null) {
                this.myDelegates = new HashSet();
                for (DelegatingNodeRendererFactoryWrapper factory : this.nodeRenderers) {
                    if (!delegates.contains(factory.getFactory().getClass())) continue;
                    this.myDelegates.add(factory.getFactory().getClass());
                }
            }
            this.nodeRenderers = null;
        }
        return this.myDelegates;
    }

    public final boolean affectsGlobalScope() {
        return false;
    }
}

