/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util.format.postgresql.format;

import com.google.common.collect.ImmutableSet;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Set;
import org.apache.calcite.util.format.postgresql.PatternModifier;
import org.apache.calcite.util.format.postgresql.format.compiled.CompiledPattern;

public abstract class FormatPattern {
    protected final String pattern;

    protected FormatPattern(String pattern) {
        this.pattern = pattern;
    }

    public CompiledPattern compilePattern(String formatString, ParsePosition formatParsePosition) throws ParseException {
        String formatTrimmed = formatString.substring(formatParsePosition.getIndex());
        int charsConsumed = 0;
        ImmutableSet.Builder modifiers = ImmutableSet.builder();
        boolean modifierFound = true;
        block0: while (modifierFound) {
            modifierFound = false;
            for (PatternModifier modifier : PatternModifier.values()) {
                if (!modifier.isPrefix() || !formatTrimmed.startsWith(modifier.getModifierString())) continue;
                modifiers.add((Object)modifier);
                formatTrimmed = formatTrimmed.substring(modifier.getModifierString().length());
                charsConsumed += modifier.getModifierString().length();
                modifierFound = true;
                continue block0;
            }
        }
        if (formatTrimmed.startsWith(this.pattern)) {
            formatTrimmed = formatString.substring(formatParsePosition.getIndex() + (charsConsumed += this.pattern.length()));
            modifierFound = true;
            block2: while (modifierFound) {
                modifierFound = false;
                for (PatternModifier modifier : PatternModifier.values()) {
                    if (modifier.isPrefix() || !formatTrimmed.startsWith(modifier.getModifierString())) continue;
                    modifiers.add((Object)modifier);
                    formatTrimmed = formatTrimmed.substring(modifier.getModifierString().length());
                    modifierFound = true;
                    continue block2;
                }
            }
            return this.buildCompiledPattern((Set<PatternModifier>)modifiers.build());
        }
        throw new ParseException("Pattern not found", formatParsePosition.getIndex());
    }

    protected abstract CompiledPattern buildCompiledPattern(Set<PatternModifier> var1);

    public String getPattern() {
        return this.pattern;
    }
}

