/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.widget;

import org.apache.hop.core.Const;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.ControlSpaceKeyAdapter;
import org.apache.hop.ui.core.widget.IGetCaretPosition;
import org.apache.hop.ui.core.widget.IInsertText;
import org.apache.hop.ui.util.EnvironmentUtils;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class TextVar
extends Composite {
    protected static Class<?> PKG = TextVar.class;
    protected String toolTipText;
    protected IGetCaretPosition getCaretPositionInterface;
    protected IInsertText insertTextInterface;
    protected ControlSpaceKeyAdapter controlSpaceKeyAdapter;
    protected IVariables variables;
    protected Text wText;
    protected ModifyListener modifyListenerTooltipText;

    public TextVar(IVariables variables, Composite composite, int flags) {
        this(variables, composite, flags, null, null, null);
    }

    public TextVar(IVariables variables, Composite composite, int flags, String toolTipText) {
        this(variables, composite, flags, toolTipText, null, null);
    }

    public TextVar(IVariables variables, Composite composite, int flags, IGetCaretPosition getCaretPositionInterface, IInsertText insertTextInterface) {
        this(variables, composite, flags, null, getCaretPositionInterface, insertTextInterface);
    }

    public TextVar(IVariables variables, Composite composite, int flags, String toolTipText, IGetCaretPosition getCaretPositionInterface, IInsertText insertTextInterface) {
        super(composite, 0);
        this.initialize(variables, composite, flags, toolTipText, getCaretPositionInterface, insertTextInterface, null);
    }

    public TextVar(Composite composite, IVariables variables, int flags, IGetCaretPosition getCaretPositionInterface, IInsertText insertTextInterface, SelectionListener selectionListener) {
        this(variables, composite, flags, null, getCaretPositionInterface, insertTextInterface, selectionListener);
    }

    public TextVar(IVariables variables, Composite composite, int flags, String toolTipText, IGetCaretPosition getCaretPositionInterface, IInsertText insertTextInterface, SelectionListener selectionListener) {
        super(composite, 0);
        this.initialize(variables, composite, flags, toolTipText, getCaretPositionInterface, insertTextInterface, selectionListener);
    }

    protected void initialize(IVariables variables, Composite composite, int flags, String toolTipText, IGetCaretPosition getCaretPositionInterface, IInsertText insertTextInterface, SelectionListener selectionListener) {
        this.toolTipText = toolTipText;
        this.getCaretPositionInterface = getCaretPositionInterface;
        this.insertTextInterface = insertTextInterface;
        this.variables = variables;
        PropsUi.setLook((Widget)this);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 0;
        formLayout.marginHeight = 0;
        formLayout.marginTop = 0;
        formLayout.marginBottom = 0;
        this.setLayout((Layout)formLayout);
        Label wImage = new Label((Composite)this, 0);
        PropsUi.setLook((Widget)wImage);
        wImage.setImage(GuiResource.getInstance().getImageVariableMini());
        wImage.setToolTipText(BaseMessages.getString(PKG, (String)"TextVar.tooltip.InsertVariable", (String[])new String[0]));
        FormData fdlImage = new FormData();
        fdlImage.top = new FormAttachment(0, 0);
        fdlImage.right = new FormAttachment(100, 0);
        wImage.setLayoutData((Object)fdlImage);
        this.wText = new Text((Composite)this, flags);
        PropsUi.setLook((Widget)this.wText);
        FormData fdText = new FormData();
        fdText.top = new FormAttachment(0, 0);
        fdText.left = new FormAttachment(0, 0);
        fdText.right = new FormAttachment((Control)wImage, 0);
        fdText.bottom = new FormAttachment(100, 0);
        this.wText.setLayoutData((Object)fdText);
        this.modifyListenerTooltipText = this.getModifyListenerTooltipText(this.wText);
        this.wText.addModifyListener(this.modifyListenerTooltipText);
        this.controlSpaceKeyAdapter = new ControlSpaceKeyAdapter(variables, (Control)this.wText, getCaretPositionInterface, insertTextInterface);
        this.wText.addKeyListener((KeyListener)this.controlSpaceKeyAdapter);
    }

    public IGetCaretPosition getGetCaretPositionInterface() {
        return this.getCaretPositionInterface;
    }

    public void setGetCaretPositionInterface(IGetCaretPosition getCaretPositionInterface) {
        this.getCaretPositionInterface = getCaretPositionInterface;
    }

    public IInsertText getInsertTextInterface() {
        return this.insertTextInterface;
    }

    public void setInsertTextInterface(IInsertText insertTextInterface) {
        this.insertTextInterface = insertTextInterface;
    }

    protected ModifyListener getModifyListenerTooltipText(Text textField) {
        return e -> {
            if (textField.getEchoChar() == '\u0000') {
                Object tip = textField.getText();
                if (!Utils.isEmpty((CharSequence)tip) && !Utils.isEmpty((CharSequence)this.toolTipText)) {
                    tip = (String)tip + Const.CR + Const.CR + this.toolTipText;
                }
                if (Utils.isEmpty((CharSequence)tip)) {
                    tip = this.toolTipText;
                }
                if (PropsUi.getInstance().resolveVariablesInToolTips()) {
                    textField.setToolTipText(this.variables.resolve((String)tip));
                } else {
                    textField.setToolTipText((String)tip);
                }
            }
        };
    }

    public String getText() {
        return this.wText.getText();
    }

    public void setText(String text) {
        this.wText.setText(text);
        this.modifyListenerTooltipText.modifyText(null);
    }

    public Text getTextWidget() {
        return this.wText;
    }

    public void addListener(int eventType, Listener listener) {
        this.wText.addListener(eventType, listener);
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.wText.addModifyListener(modifyListener);
    }

    public void addSelectionListener(SelectionAdapter lsDef) {
        this.wText.addSelectionListener((SelectionListener)lsDef);
    }

    public void addKeyListener(KeyListener lsKey) {
        this.wText.addKeyListener(lsKey);
    }

    public void addFocusListener(FocusListener lsFocus) {
        this.wText.addFocusListener(lsFocus);
    }

    public void setEchoChar(char c) {
        this.wText.setEchoChar(c);
    }

    public void setEnabled(boolean flag) {
        this.wText.setEnabled(flag);
    }

    public boolean setFocus() {
        return this.wText.setFocus();
    }

    public void addTraverseListener(TraverseListener tl) {
        this.wText.addTraverseListener(tl);
    }

    public void setToolTipText(String toolTipText) {
        this.toolTipText = toolTipText;
        this.wText.setToolTipText(toolTipText);
        this.modifyListenerTooltipText.modifyText(null);
    }

    public void setEditable(boolean editable) {
        this.wText.setEditable(editable);
    }

    public void setSelection(int i) {
        this.wText.setSelection(i);
    }

    public void selectAll() {
        this.wText.selectAll();
    }

    public void showSelection() {
        if (!EnvironmentUtils.getInstance().isWeb()) {
            this.wText.showSelection();
        }
    }

    public void setVariables(IVariables vars) {
        this.variables = vars;
        this.controlSpaceKeyAdapter.setVariables(this.variables);
        this.modifyListenerTooltipText.modifyText(null);
    }
}

