/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive.allocator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmanager.scheduler.SlotSharingGroup;
import org.apache.flink.runtime.jobmaster.SlotInfo;
import org.apache.flink.runtime.scheduler.adaptive.JobSchedulingPlan;
import org.apache.flink.runtime.scheduler.adaptive.allocator.JobAllocationsInformation;
import org.apache.flink.runtime.scheduler.adaptive.allocator.JobInformation;
import org.apache.flink.runtime.scheduler.adaptive.allocator.SlotAssigner;
import org.apache.flink.runtime.scheduler.adaptive.allocator.SlotSharingSlotAllocator;
import org.apache.flink.runtime.scheduler.adaptive.allocator.VertexParallelism;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;

public class DefaultSlotAssigner
implements SlotAssigner {
    @Override
    public Collection<JobSchedulingPlan.SlotAssignment> assignSlots(JobInformation jobInformation, Collection<? extends SlotInfo> freeSlots, VertexParallelism vertexParallelism, JobAllocationsInformation previousAllocations) {
        ArrayList<SlotSharingSlotAllocator.ExecutionSlotSharingGroup> allGroups = new ArrayList<SlotSharingSlotAllocator.ExecutionSlotSharingGroup>();
        for (SlotSharingGroup slotSharingGroup : jobInformation.getSlotSharingGroups()) {
            allGroups.addAll(DefaultSlotAssigner.createExecutionSlotSharingGroups(vertexParallelism, slotSharingGroup));
        }
        Iterator<? extends SlotInfo> iterator = freeSlots.iterator();
        ArrayList<JobSchedulingPlan.SlotAssignment> assignments = new ArrayList<JobSchedulingPlan.SlotAssignment>();
        for (SlotSharingSlotAllocator.ExecutionSlotSharingGroup group : allGroups) {
            assignments.add(new JobSchedulingPlan.SlotAssignment(iterator.next(), group));
        }
        return assignments;
    }

    static List<SlotSharingSlotAllocator.ExecutionSlotSharingGroup> createExecutionSlotSharingGroups(VertexParallelism vertexParallelism, SlotSharingGroup slotSharingGroup) {
        HashMap sharedSlotToVertexAssignment = new HashMap();
        slotSharingGroup.getJobVertexIds().forEach(jobVertexId -> {
            int parallelism = vertexParallelism.getParallelism((JobVertexID)jobVertexId);
            for (int subtaskIdx = 0; subtaskIdx < parallelism; ++subtaskIdx) {
                sharedSlotToVertexAssignment.computeIfAbsent(subtaskIdx, ignored -> new HashSet()).add(new ExecutionVertexID((JobVertexID)jobVertexId, subtaskIdx));
            }
        });
        return sharedSlotToVertexAssignment.values().stream().map(SlotSharingSlotAllocator.ExecutionSlotSharingGroup::new).collect(Collectors.toList());
    }
}

