/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.stacktrace;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.zip.InflaterInputStream;
import org.gridkit.jvmtool.codec.stacktrace.ThreadTraceEvent;
import org.gridkit.jvmtool.event.CommonEvent;
import org.gridkit.jvmtool.event.ErrorEvent;
import org.gridkit.jvmtool.event.Event;
import org.gridkit.jvmtool.event.EventMorpher;
import org.gridkit.jvmtool.event.EventReader;
import org.gridkit.jvmtool.event.MorphingEventReader;
import org.gridkit.jvmtool.event.SimpleErrorEvent;
import org.gridkit.jvmtool.event.SimpleTagCollection;
import org.gridkit.jvmtool.event.TagCollection;
import org.gridkit.jvmtool.stacktrace.CounterArray;
import org.gridkit.jvmtool.stacktrace.CounterCollection;
import org.gridkit.jvmtool.stacktrace.StackFrame;
import org.gridkit.jvmtool.stacktrace.StackFrameArray;
import org.gridkit.jvmtool.stacktrace.StackFrameList;
import org.gridkit.jvmtool.stacktrace.StackTraceCodec;

class StackTraceEventReaderV4
implements EventReader<Event> {
    private static StackFrameList EMPTY_STACK = new StackFrameArray(new StackFrame[0]);
    private DataInputStream dis;
    private List<String> stringDic = new ArrayList<String>();
    private List<StackFrame> frameDic = new ArrayList<StackFrame>();
    private List<String> dynStringDic = new ArrayList<String>();
    private List<TagCollection> tagDic = new ArrayList<TagCollection>();
    private List<CounterSet> counterDic = new ArrayList<CounterSet>();
    private boolean loaded;
    private boolean threadDetails;
    private long timestamp;
    private CounterArray counters;
    private SimpleTagCollection tags = new SimpleTagCollection();
    private StackFrameList trace;
    private ThreadEvent threadEventProxy = new ThreadEvent();
    private DataEvent dataEventProxy = new DataEvent();
    private ErrorEvent errorEventProxy;
    private boolean done;

    public StackTraceEventReaderV4(InputStream is) {
        this.dis = new DataInputStream(new BufferedInputStream(new InflaterInputStream(is), 65536));
        this.stringDic.add(null);
        this.stringDic.addAll(Arrays.asList(StackTraceCodec.PRESET_TAG_KEY_V4));
        this.dynStringDic.add(null);
        this.dynStringDic.addAll(Arrays.asList(StackTraceCodec.PRESET_TAG_TAG_V4));
        this.frameDic.add(null);
        this.tagDic.add(new SimpleTagCollection());
        this.counterDic.add(new CounterSet(new SimpleTagCollection()));
        this.loaded = false;
    }

    @Override
    public <M extends Event> EventReader<M> morph(EventMorpher<Event, M> morpher) {
        return MorphingEventReader.morph(this, morpher);
    }

    @Override
    public boolean hasNext() {
        if (!this.loaded) {
            this.loadNextEvent();
        }
        return this.loaded;
    }

    @Override
    public Event next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.loaded = false;
        if (this.errorEventProxy != null) {
            return this.errorEventProxy;
        }
        if (this.threadDetails) {
            return this.threadEventProxy;
        }
        return this.dataEventProxy;
    }

    @Override
    public Event peekNext() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.errorEventProxy != null) {
            return this.errorEventProxy;
        }
        if (this.threadDetails) {
            return this.threadEventProxy;
        }
        return this.dataEventProxy;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Event> iterator() {
        return this;
    }

    @Override
    public void dispose() {
        this.done = true;
        try {
            this.dis.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void loadNextEvent() {
        if (this.errorEventProxy != null || this.done) {
            return;
        }
        try {
            this.loadNext();
        }
        catch (Exception e) {
            try {
                this.dis.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.loaded = true;
            this.errorEventProxy = new SimpleErrorEvent(e);
        }
    }

    protected void loadNext() throws IOException {
        block7: {
            this.loaded = false;
            while (true) {
                int tag;
                if ((tag = this.dis.read()) < 0) {
                    this.done = true;
                    this.dis.close();
                    break block7;
                }
                if (tag == 3) {
                    this.readEvent();
                    this.loaded = true;
                    break block7;
                }
                if (tag == 1) {
                    String str = this.dis.readUTF();
                    this.stringDic.add(str);
                    continue;
                }
                if (tag == 2) {
                    StackFrame ste = this.readStackTraceElement();
                    this.frameDic.add(ste);
                    continue;
                }
                if (tag == 4) {
                    int id = StackTraceCodec.readVarInt(this.dis);
                    String str = this.dis.readUTF();
                    this.ensureSlot(this.dynStringDic, id);
                    this.dynStringDic.set(id, str);
                    continue;
                }
                if (tag == 5) {
                    this.readCounterSet();
                    continue;
                }
                if (tag != 6) break;
                this.readTagSet();
            }
            throw new IOException("Data format error");
        }
    }

    protected void readEvent() throws IOException {
        this.threadDetails = false;
        TagCollection tc = this.tagDic.get(StackTraceCodec.readVarInt(this.dis));
        this.tags = new SimpleTagCollection(tc);
        this.readEventTimestamp();
        this.readEventCounters();
        this.readEventStackTrace();
        this.tags.remove("(stored-parts)");
    }

    protected void readEventStackTrace() throws IOException {
        if (this.tags.contains("(stored-parts)", "thread-stack")) {
            this.threadDetails = true;
            this.readStackTrace();
        } else {
            this.trace = null;
        }
    }

    protected void readEventCounters() throws IOException {
        if (this.tags.contains("(stored-parts)", "counters")) {
            this.readCounters();
        } else {
            this.counters = this.counterDic.get((int)0).counters;
        }
    }

    protected void readEventTimestamp() throws IOException {
        this.timestamp = this.tags.contains("(stored-parts)", "timestamp") ? StackTraceCodec.readTimestamp(this.dis) : Long.MIN_VALUE;
    }

    protected Thread.State readState() throws IOException {
        int n = StackTraceCodec.readVarInt(this.dis);
        return n == 0 ? null : Thread.State.values()[n - 1];
    }

    protected void readTagSet() throws IOException {
        int n = StackTraceCodec.readVarInt(this.dis);
        int base = StackTraceCodec.readVarInt(this.dis);
        SimpleTagCollection ts = new SimpleTagCollection(this.tagDic.get(base));
        this.readTagSetDelta(ts);
        this.ensureSlot(this.tagDic, n);
        this.tagDic.set(n, ts);
    }

    protected void readCounterSet() throws IOException {
        int n = StackTraceCodec.readVarInt(this.dis);
        int base = StackTraceCodec.readVarInt(this.dis);
        SimpleTagCollection ts = new SimpleTagCollection(this.counterDic.get((int)base).definition);
        this.readTagSetDelta(ts);
        this.ensureSlot(this.counterDic, n);
        CounterSet cs = new CounterSet(ts);
        this.counterDic.set(n, cs);
    }

    protected void readTagSetDelta(SimpleTagCollection ts) throws IOException {
        byte btag;
        SimpleTagCollection ap = new SimpleTagCollection();
        while ((btag = this.dis.readByte()) != 0) {
            String tag;
            String key;
            if (btag == 1) {
                key = this.readString();
                tag = this.readDynString();
                ap.put(key, tag);
                continue;
            }
            if (btag == 3) {
                key = this.readString();
                tag = this.readDynString();
                ts.remove(key);
                ap.put(key, tag);
                continue;
            }
            if (btag == 2) {
                key = this.readString();
                ap.put(key, "");
                continue;
            }
            if (btag == 4) {
                key = this.readString();
                ts.remove(key);
                continue;
            }
            if (btag == 5) {
                key = this.readString();
                tag = this.readDynString();
                ts.remove(key, tag);
                continue;
            }
            throw new IOException("Unexpected tag '" + btag + "'");
        }
        ts.putAll(ap);
    }

    private String readString() throws IOException {
        int id = StackTraceCodec.readVarInt(this.dis);
        if (id < 0 || id >= this.stringDic.size()) {
            throw new IOException("Illegal string ref #" + id);
        }
        return this.stringDic.get(id);
    }

    private String readDynString() throws IOException {
        int id = StackTraceCodec.readVarInt(this.dis);
        if (id < 0 || id >= this.dynStringDic.size()) {
            throw new IOException("Illegal string ref #" + id);
        }
        return this.dynStringDic.get(id);
    }

    protected void readCounters() throws IOException {
        int csid = StackTraceCodec.readVarInt(this.dis);
        CounterSet cs = this.counterDic.get(csid);
        for (int i = 0; i != cs.values.length; ++i) {
            cs.values[i] = StackTraceCodec.readVarLong(this.dis);
        }
        this.counters = cs.counters;
    }

    protected void readStackTrace() throws IOException {
        int len = StackTraceCodec.readVarInt(this.dis);
        if (len == 0) {
            this.trace = EMPTY_STACK;
            return;
        }
        StackFrame[] frames = new StackFrame[len];
        for (int i = 0; i != len; ++i) {
            int ref = StackTraceCodec.readVarInt(this.dis);
            frames[i] = this.frameDic.get(ref);
        }
        this.trace = new StackFrameArray(frames);
    }

    private StackFrame readStackTraceElement() throws IOException {
        int npkg = StackTraceCodec.readVarInt(this.dis);
        int ncn = StackTraceCodec.readVarInt(this.dis);
        int nmtd = StackTraceCodec.readVarInt(this.dis);
        int nfile = StackTraceCodec.readVarInt(this.dis);
        int line = StackTraceCodec.readVarInt(this.dis) - 2;
        String cp = this.stringDic.get(npkg);
        String cn = this.stringDic.get(ncn);
        String mtd = this.stringDic.get(nmtd);
        String file = this.stringDic.get(nfile);
        StackFrame e = new StackFrame(cp, cn, mtd, file, line);
        return e;
    }

    private void ensureSlot(List<?> list, int n) {
        while (list.size() < n + 1) {
            list.add(null);
        }
    }

    private static class CounterSet {
        TagCollection definition;
        String[] names;
        long[] values;
        CounterArray counters;

        public CounterSet(TagCollection tags) {
            this.definition = tags;
            ArrayList<String> n = new ArrayList<String>();
            for (String key : tags) {
                n.add(key);
            }
            this.names = n.toArray(new String[n.size()]);
            this.values = new long[this.names.length];
            this.counters = new CounterArray(this.names, this.values);
        }
    }

    private class ThreadEvent
    extends DataEvent
    implements ThreadTraceEvent {
        private ThreadEvent() {
        }

        @Override
        public StackFrameList stackTrace() {
            return StackTraceEventReaderV4.this.trace;
        }
    }

    private class DataEvent
    implements CommonEvent {
        private DataEvent() {
        }

        @Override
        public long timestamp() {
            return StackTraceEventReaderV4.this.timestamp;
        }

        @Override
        public CounterCollection counters() {
            return StackTraceEventReaderV4.this.counters;
        }

        @Override
        public TagCollection tags() {
            return StackTraceEventReaderV4.this.tags;
        }
    }
}

