/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.fieldmanager;

import org.datanucleus.ExecutionContext;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;

public abstract class AbstractStoreFieldManager
extends AbstractFieldManager {
    protected ExecutionContext ec;
    protected DNStateManager sm;
    protected AbstractClassMetaData cmd;
    protected boolean insert;

    public AbstractStoreFieldManager(ExecutionContext ec, AbstractClassMetaData cmd, boolean insert) {
        this.ec = ec;
        this.cmd = cmd;
        this.insert = insert;
    }

    public AbstractStoreFieldManager(DNStateManager sm, boolean insert) {
        this.ec = sm.getExecutionContext();
        this.sm = sm;
        this.cmd = sm.getClassMetaData();
        this.insert = insert;
    }

    protected boolean isStorable(int fieldNumber) {
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        return this.isStorable(mmd);
    }

    protected boolean isStorable(AbstractMemberMetaData mmd) {
        if (mmd.getPersistenceModifier() != FieldPersistenceModifier.PERSISTENT) {
            return false;
        }
        return this.insert && mmd.isInsertable() || !this.insert && mmd.isUpdateable();
    }
}

