/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.queries;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.api.LockComponent;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.txn.jdbc.QueryHandler;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class GetWriteIdsHandler
implements QueryHandler<Map<Pair<String, String>, Long>> {
    private static final String SELECT_WRITE_ID_QUERY = "SELECT \"T2W_DATABASE\", \"T2W_TABLE\", \"T2W_WRITEID\" FROM \"TXN_TO_WRITE_ID\" WHERE \"T2W_TXNID\" = :txnId ";
    private final LockRequest lockRequest;

    public GetWriteIdsHandler(LockRequest lockRequest) {
        this.lockRequest = lockRequest;
    }

    @Override
    public String getParameterizedQueryString(DatabaseProduct databaseProduct) throws MetaException {
        StringBuilder sb = new StringBuilder(SELECT_WRITE_ID_QUERY);
        sb.append(" AND (");
        for (int i = 0; i < this.lockRequest.getComponentSize(); ++i) {
            sb.append("(\"T2W_DATABASE\" = ").append(":db").append(i).append(" AND \"T2W_TABLE\" = :table").append(i).append(")");
            if (i >= this.lockRequest.getComponentSize() - 1) continue;
            sb.append(" OR ");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public SqlParameterSource getQueryParameters() {
        MapSqlParameterSource params = new MapSqlParameterSource().addValue("txnId", (Object)this.lockRequest.getTxnid());
        for (int i = 0; i < this.lockRequest.getComponentSize(); ++i) {
            params.addValue("db" + i, (Object)((LockComponent)this.lockRequest.getComponent().get(i)).getDbname());
            params.addValue("table" + i, (Object)((LockComponent)this.lockRequest.getComponent().get(i)).getTablename());
        }
        return params;
    }

    public Map<Pair<String, String>, Long> extractData(ResultSet rs) throws SQLException, DataAccessException {
        HashMap<Pair<String, String>, Long> writeIds = new HashMap<Pair<String, String>, Long>();
        while (rs.next()) {
            writeIds.put((Pair<String, String>)Pair.of((Object)rs.getString("T2W_DATABASE"), (Object)rs.getString("T2W_TABLE")), rs.getLong("T2W_WRITEID"));
        }
        return writeIds;
    }
}

