/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.lib;

import org.apache.hadoop.hive.ql.exec.ConditionalTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.SemanticDispatcher;
import org.apache.hadoop.hive.ql.parse.SemanticException;

public class PreOrderWalker
extends DefaultGraphWalker {
    public PreOrderWalker(SemanticDispatcher disp) {
        super(disp);
    }

    @Override
    protected void walk(Node nd) throws SemanticException {
        this.opStack.push(nd);
        this.dispatch(nd, this.opStack);
        if (nd.getChildren() != null) {
            for (Node n : nd.getChildren()) {
                this.walk(n);
            }
        } else if (nd instanceof ConditionalTask) {
            for (Task<?> n : ((ConditionalTask)nd).getListTasks()) {
                if (n.getParentTasks() != null && !n.getParentTasks().isEmpty()) continue;
                this.walk(n);
            }
        }
        this.opStack.pop();
    }
}

