/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.ptf;

import com.google.common.base.Preconditions;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorBase;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;

public class VectorPTFEvaluatorStreamingDecimalMax
extends VectorPTFEvaluatorBase {
    protected boolean isNull;
    protected HiveDecimalWritable max = new HiveDecimalWritable();

    public VectorPTFEvaluatorStreamingDecimalMax(WindowFrameDef windowFrameDef, VectorExpression inputVecExpr, int outputColumnNum) {
        super(windowFrameDef, inputVecExpr, outputColumnNum);
        this.resetEvaluator();
    }

    @Override
    public void evaluateGroupBatch(VectorizedRowBatch batch) throws HiveException {
        this.evaluateInputExpr(batch);
        Preconditions.checkState((!batch.selectedInUse ? 1 : 0) != 0);
        int size = batch.size;
        if (size == 0) {
            return;
        }
        DecimalColumnVector decimalColVector = (DecimalColumnVector)batch.cols[this.inputColumnNum];
        DecimalColumnVector outputColVector = (DecimalColumnVector)batch.cols[this.outputColumnNum];
        if (decimalColVector.isRepeating) {
            if (decimalColVector.noNulls || !decimalColVector.isNull[0]) {
                HiveDecimalWritable repeatedMax = decimalColVector.vector[0];
                if (this.isNull) {
                    this.max.set(repeatedMax);
                    this.isNull = false;
                } else if (repeatedMax.compareTo(this.max) == 1) {
                    this.max.set(repeatedMax);
                }
                outputColVector.set(0, this.max);
            } else if (this.isNull) {
                outputColVector.isNull[0] = true;
                outputColVector.noNulls = false;
            } else {
                outputColVector.set(0, this.max);
            }
            outputColVector.isRepeating = true;
        } else if (decimalColVector.noNulls) {
            HiveDecimalWritable[] vector = decimalColVector.vector;
            for (int i = 0; i < size; ++i) {
                HiveDecimalWritable value = vector[i];
                if (this.isNull) {
                    this.max.set(value);
                    this.isNull = false;
                } else if (value.compareTo(this.max) == 1) {
                    this.max.set(value);
                }
                outputColVector.set(i, this.max);
            }
        } else {
            boolean[] batchIsNull = decimalColVector.isNull;
            int i = 0;
            while (batchIsNull[i]) {
                if (this.isNull) {
                    outputColVector.isNull[i] = true;
                    outputColVector.noNulls = false;
                } else {
                    outputColVector.set(i, this.max);
                }
                if (++i < size) continue;
                return;
            }
            HiveDecimalWritable[] vector = decimalColVector.vector;
            HiveDecimalWritable firstValue = vector[i];
            if (this.isNull) {
                this.max.set(firstValue);
                this.isNull = false;
            } else if (firstValue.compareTo(this.max) == 1) {
                this.max.set(firstValue);
            }
            outputColVector.set(i++, this.max);
            while (i < size) {
                if (!batchIsNull[i]) {
                    HiveDecimalWritable value = vector[i];
                    if (this.isNull) {
                        this.max.set(value);
                        this.isNull = false;
                    } else if (value.compareTo(this.max) == 1) {
                        this.max.set(value);
                    }
                    outputColVector.set(i, this.max);
                } else {
                    outputColVector.set(i, this.max);
                }
                ++i;
            }
        }
    }

    @Override
    public boolean streamsResult() {
        return true;
    }

    @Override
    public ColumnVector.Type getResultColumnVectorType() {
        return ColumnVector.Type.DECIMAL;
    }

    @Override
    public void resetEvaluator() {
        this.isNull = true;
        this.max.set(HiveDecimal.ZERO);
    }
}

