/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.catalog.drop;

import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.catalog.drop.DropCatalogDesc;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={1004})
public class DropCatalogAnalyzer
extends BaseSemanticAnalyzer {
    public DropCatalogAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        boolean ifExists;
        String catalogName = DropCatalogAnalyzer.unescapeIdentifier(root.getChild(0).getText());
        Catalog catalog = this.getCatalog(catalogName, !(ifExists = root.getFirstChildWithType(1054) != null));
        if (catalog == null) {
            return;
        }
        this.inputs.add(new ReadEntity(catalog));
        this.outputs.add(new WriteEntity(catalog, WriteEntity.WriteType.DDL_NO_LOCK));
        DropCatalogDesc desc = new DropCatalogDesc(catalogName, ifExists);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
    }
}

