/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.queue.impl;

import io.lettuce.core.KeyValue;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.sync.RedisCommands;
import io.lettuce.core.codec.RedisCodec;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.hertzbeat.common.config.CommonProperties;
import org.apache.hertzbeat.common.entity.log.LogEntry;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.queue.CommonDataQueue;
import org.apache.hertzbeat.common.serialize.RedisLogEntryCodec;
import org.apache.hertzbeat.common.serialize.RedisMetricsDataCodec;
import org.apache.hertzbeat.common.support.exception.CommonDataQueueUnknownException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="common.queue", name={"type"}, havingValue="redis")
public class RedisCommonDataQueue
implements CommonDataQueue,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(RedisCommonDataQueue.class);
    private final RedisClient redisClient;
    private final StatefulRedisConnection<String, CollectRep.MetricsData> connection;
    private final RedisCommands<String, CollectRep.MetricsData> syncCommands;
    private final StatefulRedisConnection<String, LogEntry> logEntryConnection;
    private final RedisCommands<String, LogEntry> logEntrySyncCommands;
    private final String metricsDataQueueNameToStorage;
    private final String metricsDataQueueNameForServiceDiscovery;
    private final String metricsDataQueueNameToAlerter;
    private final String logEntryQueueName;
    private final String logEntryToStorageQueueName;
    private final CommonProperties.RedisProperties redisProperties;
    private final Long waitTimeout;

    public RedisCommonDataQueue(CommonProperties properties) {
        if (properties == null || properties.getQueue() == null || properties.getQueue().getRedis() == null) {
            log.error("init error, please config common.queue.redis props in application.yml");
            throw new IllegalArgumentException("please config common.queue.redis props");
        }
        this.redisProperties = properties.getQueue().getRedis();
        this.redisClient = RedisClient.create((RedisURI)RedisURI.builder().withHost(this.redisProperties.getRedisHost()).withPort(this.redisProperties.getRedisPort()).build());
        RedisMetricsDataCodec codec = new RedisMetricsDataCodec();
        this.connection = this.redisClient.connect((RedisCodec)codec);
        this.syncCommands = this.connection.sync();
        RedisLogEntryCodec logCodec = new RedisLogEntryCodec();
        this.logEntryConnection = this.redisClient.connect((RedisCodec)logCodec);
        this.logEntrySyncCommands = this.logEntryConnection.sync();
        this.metricsDataQueueNameToStorage = this.redisProperties.getMetricsDataQueueNameToPersistentStorage();
        this.metricsDataQueueNameForServiceDiscovery = this.redisProperties.getMetricsDataQueueNameForServiceDiscovery();
        this.metricsDataQueueNameToAlerter = this.redisProperties.getMetricsDataQueueNameToAlerter();
        this.logEntryQueueName = this.redisProperties.getLogEntryQueueName();
        this.logEntryToStorageQueueName = this.redisProperties.getLogEntryToStorageQueueName();
        this.waitTimeout = Objects.requireNonNullElse(this.redisProperties.getWaitTimeout(), 1L);
    }

    @Override
    public CollectRep.MetricsData pollMetricsDataToAlerter() throws InterruptedException {
        return this.genericBlockingPollFunction(this.metricsDataQueueNameToAlerter, this.syncCommands);
    }

    @Override
    public CollectRep.MetricsData pollMetricsDataToStorage() throws InterruptedException {
        return this.genericBlockingPollFunction(this.metricsDataQueueNameToStorage, this.syncCommands);
    }

    @Override
    public CollectRep.MetricsData pollServiceDiscoveryData() throws InterruptedException {
        return this.genericBlockingPollFunction(this.metricsDataQueueNameForServiceDiscovery, this.syncCommands);
    }

    @Override
    public void sendMetricsData(CollectRep.MetricsData metricsData) {
        try {
            this.syncCommands.lpush((Object)this.metricsDataQueueNameToAlerter, (Object[])new CollectRep.MetricsData[]{metricsData});
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    @Override
    public void sendMetricsDataToStorage(CollectRep.MetricsData metricsData) {
        try {
            this.syncCommands.lpush((Object)this.metricsDataQueueNameToStorage, (Object[])new CollectRep.MetricsData[]{metricsData});
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    @Override
    public void sendServiceDiscoveryData(CollectRep.MetricsData metricsData) {
        try {
            this.syncCommands.lpush((Object)this.metricsDataQueueNameForServiceDiscovery, (Object[])new CollectRep.MetricsData[]{metricsData});
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    @Override
    public void sendLogEntry(LogEntry logEntry) {
        try {
            this.logEntrySyncCommands.lpush((Object)this.logEntryQueueName, (Object[])new LogEntry[]{logEntry});
        }
        catch (Exception e) {
            log.error("Failed to send LogEntry to Redis: {}", (Object)e.getMessage());
        }
    }

    @Override
    public LogEntry pollLogEntry() throws InterruptedException {
        return this.genericBlockingPollFunction(this.logEntryQueueName, this.logEntrySyncCommands);
    }

    @Override
    public void sendLogEntryToStorage(LogEntry logEntry) {
        try {
            this.logEntrySyncCommands.lpush((Object)this.logEntryToStorageQueueName, (Object[])new LogEntry[]{logEntry});
        }
        catch (Exception e) {
            log.error("Failed to send LogEntry to storage via Redis: {}", (Object)e.getMessage());
        }
    }

    @Override
    public LogEntry pollLogEntryToStorage() throws InterruptedException {
        return this.genericBlockingPollFunction(this.logEntryToStorageQueueName, this.logEntrySyncCommands);
    }

    @Override
    public void sendLogEntryToAlertBatch(List<LogEntry> logEntries) {
        if (logEntries == null || logEntries.isEmpty()) {
            return;
        }
        try {
            this.logEntrySyncCommands.lpush((Object)this.logEntryQueueName, (Object[])logEntries.toArray(new LogEntry[0]));
        }
        catch (Exception e) {
            log.error("Failed to send LogEntry batch to Redis: {}", (Object)e.getMessage());
        }
    }

    @Override
    public List<LogEntry> pollLogEntryToAlertBatch(int maxBatchSize) throws InterruptedException {
        return this.genericBatchPollFunction(this.logEntryQueueName, this.logEntrySyncCommands, maxBatchSize);
    }

    @Override
    public void sendLogEntryToStorageBatch(List<LogEntry> logEntries) {
        if (logEntries == null || logEntries.isEmpty()) {
            return;
        }
        try {
            this.logEntrySyncCommands.lpush((Object)this.logEntryToStorageQueueName, (Object[])logEntries.toArray(new LogEntry[0]));
        }
        catch (Exception e) {
            log.error("Failed to send LogEntry batch to storage via Redis: {}", (Object)e.getMessage());
        }
    }

    @Override
    public List<LogEntry> pollLogEntryToStorageBatch(int maxBatchSize) throws InterruptedException {
        return this.genericBatchPollFunction(this.logEntryToStorageQueueName, this.logEntrySyncCommands, maxBatchSize);
    }

    public void destroy() {
        this.connection.close();
        this.logEntryConnection.close();
        this.redisClient.shutdown();
    }

    private <T> T genericBlockingPollFunction(String key, RedisCommands<String, T> commands) throws InterruptedException {
        try {
            KeyValue keyData = commands.brpop(this.waitTimeout.longValue(), (Object[])new String[]{key});
            if (keyData != null) {
                return (T)keyData.getValue();
            }
            return null;
        }
        catch (Exception e) {
            log.error("Redis BRPOP failed: {}", (Object)e.getMessage());
            throw new CommonDataQueueUnknownException(e.getMessage(), e);
        }
    }

    private List<LogEntry> genericBatchPollFunction(String key, RedisCommands<String, LogEntry> commands, int maxBatchSize) {
        ArrayList<LogEntry> batch = new ArrayList<LogEntry>(maxBatchSize);
        try {
            List elements = commands.rpop((Object)key, (long)maxBatchSize);
            if (elements != null) {
                batch.addAll(elements);
            }
        }
        catch (Exception e) {
            log.error("Redis batch poll failed: {}", (Object)e.getMessage());
        }
        return batch;
    }
}

