/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.desc;

import dm.jdbc.b.a.a;
import dm.jdbc.desc.Column;
import dm.jdbc.desc.SQLName;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.util.ByteUtil;
import dm.jdbc.util.DriverUtil;
import java.io.Serializable;
import java.nio.charset.Charset;

public class TypeDescriptor
implements Serializable {
    public static final int OBJ_BLOB_MAGIC = 78111999;
    public static final int CLTN_TYPE_IND_TABLE = 3;
    public static final int CLTN_TYPE_NST_TABLE = 2;
    public static final int CLTN_TYPE_VARRAY = 1;
    private static final long serialVersionUID = 1L;
    public Column column = new Column();
    public SQLName m_sqlName = null;
    int m_objId = -1;
    int m_objVersion = -1;
    int m_outerId = 0;
    int m_outerVer = 0;
    int m_subId = 0;
    int m_cltnType = 0;
    int m_maxCnt = 0;
    int m_length = 0;
    int m_size = 0;
    public DmdbConnection m_conn = null;
    private Charset m_serverEncoding = null;
    public TypeDescriptor m_arrObj = null;
    public TypeDescriptor[] m_fieldsObj = null;
    byte[] m_descBuf = null;

    public TypeDescriptor(String string, DmdbConnection dmdbConnection) {
        this.m_sqlName = new SQLName(string);
        this.m_conn = dmdbConnection;
    }

    public TypeDescriptor(DmdbConnection dmdbConnection) {
        this.m_sqlName = new SQLName(dmdbConnection);
        this.m_conn = dmdbConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseDescByName() {
        DmdbConnection dmdbConnection = this.m_conn;
        synchronized (dmdbConnection) {
            String string = "BEGIN ? = SF_DESCRIBE_TYPE(?); END;";
            Object[] objectArray = new Object[2];
            objectArray[1] = this.m_sqlName.m_fulName;
            Integer[] integerArray = new Integer[2];
            integerArray[0] = 2004;
            Object[] objectArray2 = DriverUtil.executePrepareCall(this.m_conn, string, objectArray, integerArray);
            DmdbBlob dmdbBlob = (DmdbBlob)objectArray2[0];
            byte[] byArray = dmdbBlob.do_getBytes(1L, (int)dmdbBlob.do_length());
            this.m_serverEncoding = this.m_conn.getServerEncoding();
            this.unpack(a.a(byArray, false, this.m_conn.bufferType));
        }
    }

    public String getFulName() {
        return this.m_sqlName.getFulName();
    }

    public int getDType() {
        return this.column.type;
    }

    public int getPrec() {
        return this.column.prec;
    }

    public int getScale() {
        return this.column.scale;
    }

    public Charset getServerEncoding() {
        return this.m_serverEncoding == null ? this.m_conn.getServerEncoding() : this.m_serverEncoding;
    }

    public int getObjId() {
        return this.m_objId;
    }

    public int getStaticArrayLength() {
        return this.m_length;
    }

    public int getStrctMemSize() {
        return this.m_size;
    }

    public int getOuterId() {
        return this.m_outerId;
    }

    public int getCltnType() {
        return this.m_cltnType;
    }

    public int getMaxCnt() {
        return this.m_maxCnt;
    }

    private static int getPackSize(TypeDescriptor typeDescriptor) {
        int n2 = 0;
        switch (typeDescriptor.column.type) {
            case 117: 
            case 122: {
                return TypeDescriptor.getPackArraySize(typeDescriptor);
            }
            case 119: {
                return TypeDescriptor.getPackClassSize(typeDescriptor);
            }
            case 121: {
                return TypeDescriptor.getPackRecordSize(typeDescriptor);
            }
        }
        n2 += 4;
        n2 += 4;
        return n2 += 4;
    }

    private static void pack(TypeDescriptor typeDescriptor, a a2) {
        switch (typeDescriptor.column.type) {
            case 117: 
            case 122: {
                TypeDescriptor.packArray(typeDescriptor, a2);
                return;
            }
            case 119: {
                TypeDescriptor.packClass(typeDescriptor, a2);
                return;
            }
            case 121: {
                TypeDescriptor.packRecord(typeDescriptor, a2);
                return;
            }
        }
        a2.g(typeDescriptor.column.type);
        a2.g(typeDescriptor.column.prec);
        a2.g(typeDescriptor.column.scale);
    }

    public static int getPackArraySize(TypeDescriptor typeDescriptor) {
        int n2 = 0;
        n2 += 4;
        String string = typeDescriptor.m_sqlName.m_name;
        n2 += 2;
        byte[] byArray = ByteUtil.fromString(string, typeDescriptor.getServerEncoding());
        n2 += byArray.length;
        n2 += 4;
        n2 += 4;
        n2 += 4;
        return n2 += TypeDescriptor.getPackSize(typeDescriptor.m_arrObj);
    }

    public static void packArray(TypeDescriptor typeDescriptor, a a2) {
        a2.g(typeDescriptor.column.type);
        a2.c(typeDescriptor.m_sqlName.m_name, typeDescriptor.getServerEncoding());
        a2.g(typeDescriptor.m_objId);
        a2.g(typeDescriptor.m_objVersion);
        a2.g(typeDescriptor.m_length);
        TypeDescriptor.pack(typeDescriptor.m_arrObj, a2);
    }

    public static void packRecord(TypeDescriptor typeDescriptor, a a2) {
        a2.g(typeDescriptor.column.type);
        a2.c(typeDescriptor.m_sqlName.m_name, typeDescriptor.getServerEncoding());
        a2.g(typeDescriptor.m_objId);
        a2.g(typeDescriptor.m_objVersion);
        a2.a((short)typeDescriptor.m_size);
        int n2 = 0;
        while (n2 < typeDescriptor.m_size) {
            TypeDescriptor.pack(typeDescriptor.m_fieldsObj[n2], a2);
            ++n2;
        }
    }

    public static int getPackRecordSize(TypeDescriptor typeDescriptor) {
        int n2 = 0;
        n2 += 4;
        String string = typeDescriptor.m_sqlName.m_name;
        n2 += 2;
        byte[] byArray = ByteUtil.fromString(string, typeDescriptor.getServerEncoding());
        n2 += byArray.length;
        n2 += 4;
        n2 += 4;
        n2 += 2;
        int n3 = 0;
        while (n3 < typeDescriptor.m_size) {
            n2 += TypeDescriptor.getPackSize(typeDescriptor.m_fieldsObj[n3]);
            ++n3;
        }
        return n2;
    }

    public static int getPackClassSize(TypeDescriptor typeDescriptor) {
        int n2 = 0;
        n2 += 4;
        String string = typeDescriptor.m_sqlName.m_name;
        n2 += 2;
        byte[] byArray = ByteUtil.fromString(string, typeDescriptor.getServerEncoding());
        n2 += byArray.length;
        n2 += 4;
        n2 += 4;
        if (typeDescriptor.m_objId == 4) {
            n2 += 4;
            n2 += 4;
            n2 += 2;
        }
        return n2;
    }

    public static void packClass(TypeDescriptor typeDescriptor, a a2) {
        a2.g(typeDescriptor.column.type);
        a2.c(typeDescriptor.m_sqlName.m_name, typeDescriptor.getServerEncoding());
        a2.g(typeDescriptor.m_objId);
        a2.g(typeDescriptor.m_objVersion);
        if (typeDescriptor.m_objId == 4) {
            a2.g(typeDescriptor.m_outerId);
            a2.g(typeDescriptor.m_outerVer);
            a2.i(typeDescriptor.m_subId);
        }
    }

    public void unpack(a a2) {
        this.column.type = a2.readInt();
        switch (this.column.type) {
            case 117: 
            case 122: {
                this.unpackArray(a2);
                return;
            }
            case 119: {
                this.unpackClass(a2);
                return;
            }
            case 121: {
                this.unpackRecord(a2);
                return;
            }
        }
        this.column.prec = a2.readInt();
        this.column.scale = a2.readInt();
    }

    private void unpackArray(a a2) {
        this.m_sqlName.m_name = a2.c(this.getServerEncoding());
        this.m_sqlName.m_schId = a2.readInt();
        this.m_sqlName.m_packId = a2.readInt();
        this.m_objId = a2.readInt();
        this.m_objVersion = a2.readInt();
        this.m_length = a2.readInt();
        if (this.column.type == 117) {
            this.m_length = 0;
        }
        this.m_arrObj = new TypeDescriptor(this.m_conn);
        this.m_arrObj.unpack(a2);
    }

    private void unpackRecord(a a2) {
        this.m_sqlName.m_name = a2.c(this.getServerEncoding());
        this.m_sqlName.m_schId = a2.readInt();
        this.m_sqlName.m_packId = a2.readInt();
        this.m_objId = a2.readInt();
        this.m_objVersion = a2.readInt();
        this.m_size = a2.g();
        this.m_fieldsObj = new TypeDescriptor[this.m_size];
        int n2 = 0;
        while (n2 < this.m_size) {
            this.m_fieldsObj[n2] = new TypeDescriptor(this.m_conn);
            this.m_fieldsObj[n2].unpack(a2);
            ++n2;
        }
    }

    private void unpackClnt_nestTab(a a2) {
        this.m_maxCnt = a2.readInt();
        this.m_arrObj = new TypeDescriptor(this.m_conn);
        this.m_arrObj.unpack(a2);
    }

    private void unpackClnt(a a2) {
        this.m_outerId = a2.readInt();
        this.m_outerVer = a2.readInt();
        this.m_subId = a2.g();
        this.m_cltnType = a2.g();
        switch (this.m_cltnType) {
            case 3: {
                DBError.ECJDBC_UNSUPPORTED_TYPE.throwz(new Object[0]);
                break;
            }
            case 1: 
            case 2: {
                this.unpackClnt_nestTab(a2);
            }
        }
    }

    private void unpackClass(a a2) {
        this.m_sqlName.m_name = a2.c(this.getServerEncoding());
        this.m_sqlName.m_schId = a2.readInt();
        this.m_sqlName.m_packId = a2.readInt();
        this.m_objId = a2.readInt();
        this.m_objVersion = a2.readInt();
        if (this.m_objId == 4) {
            this.unpackClnt(a2);
        } else {
            this.m_size = a2.g();
            this.m_fieldsObj = new TypeDescriptor[this.m_size];
            int n2 = 0;
            while (n2 < this.m_size) {
                this.m_fieldsObj[n2] = new TypeDescriptor(this.m_conn);
                this.m_fieldsObj[n2].unpack(a2);
                ++n2;
            }
        }
    }

    private int calcChkDescLen_array(TypeDescriptor typeDescriptor) {
        int n2 = 0;
        n2 += 2;
        n2 += 4;
        return n2 += this.calcChkDescLen(typeDescriptor.m_arrObj);
    }

    private int calcChkDescLen_record(TypeDescriptor typeDescriptor) {
        int n2 = 0;
        n2 += 2;
        n2 += 2;
        int n3 = 0;
        while (n3 < typeDescriptor.m_size) {
            n2 += this.calcChkDescLen(typeDescriptor.m_fieldsObj[n3]);
            ++n3;
        }
        return n2;
    }

    private int calcChkDescLen_class_normal(TypeDescriptor typeDescriptor) {
        int n2 = 0;
        n2 += 2;
        int n3 = 0;
        while (n3 < typeDescriptor.m_size) {
            n2 += this.calcChkDescLen(typeDescriptor.m_fieldsObj[n3]);
            ++n3;
        }
        return n2;
    }

    private int calcChkDescLen_class_cnlt(TypeDescriptor typeDescriptor) {
        int n2 = 0;
        n2 += 2;
        n2 += 4;
        switch (typeDescriptor.getCltnType()) {
            case 3: {
                DBError.ECJDBC_UNSUPPORTED_TYPE.throwz(new Object[0]);
                break;
            }
            case 1: 
            case 2: {
                n2 += this.calcChkDescLen(typeDescriptor.m_arrObj);
            }
        }
        return n2;
    }

    private int calcChkDescLen_class(TypeDescriptor typeDescriptor) {
        int n2 = 0;
        n2 += 2;
        ++n2;
        n2 = typeDescriptor.m_objId == 4 ? (n2 += this.calcChkDescLen_class_cnlt(typeDescriptor)) : (n2 += this.calcChkDescLen_class_normal(typeDescriptor));
        return n2;
    }

    private int calcChkDescLen_buildin() {
        int n2 = 0;
        n2 += 2;
        n2 += 2;
        return n2 += 2;
    }

    private int calcChkDescLen(TypeDescriptor typeDescriptor) {
        int n2;
        switch (typeDescriptor.getDType()) {
            case 117: 
            case 122: {
                n2 = this.calcChkDescLen_array(typeDescriptor);
                break;
            }
            case 121: {
                n2 = this.calcChkDescLen_record(typeDescriptor);
                break;
            }
            case 119: {
                n2 = this.calcChkDescLen_class(typeDescriptor);
                break;
            }
            default: {
                n2 = this.calcChkDescLen_buildin();
            }
        }
        return n2;
    }

    private int makeChkDesc_array(int n2, TypeDescriptor typeDescriptor) {
        ByteUtil.setShort(this.m_descBuf, n2, (short)117);
        ByteUtil.setInt(this.m_descBuf, n2 += 2, typeDescriptor.m_length);
        n2 += 4;
        n2 = this.makeChkDesc(n2, typeDescriptor.m_arrObj);
        return n2;
    }

    private int makeChkDesc_record(int n2, TypeDescriptor typeDescriptor) {
        ByteUtil.setShort(this.m_descBuf, n2, (short)121);
        ByteUtil.setShort(this.m_descBuf, n2 += 2, (short)typeDescriptor.m_size);
        n2 += 2;
        int n3 = 0;
        while (n3 < typeDescriptor.m_size) {
            n2 = this.makeChkDesc(n2, typeDescriptor.m_fieldsObj[n3]);
            ++n3;
        }
        return n2;
    }

    private int makeChkDesc_buildin(int n2, TypeDescriptor typeDescriptor) {
        short s2 = (short)typeDescriptor.getDType();
        short s3 = 0;
        short s4 = 0;
        if (s2 != 12) {
            s3 = (short)typeDescriptor.getPrec();
            s4 = (short)typeDescriptor.getScale();
        }
        ByteUtil.setShort(this.m_descBuf, n2, s2);
        ByteUtil.setShort(this.m_descBuf, n2 += 2, s3);
        ByteUtil.setShort(this.m_descBuf, n2 += 2, s4);
        return n2 += 2;
    }

    private int makeChkDesc_class_normal(int n2, TypeDescriptor typeDescriptor) {
        ByteUtil.setShort(this.m_descBuf, n2, (short)typeDescriptor.m_size);
        n2 += 2;
        int n3 = 0;
        while (n3 < typeDescriptor.m_size) {
            n2 = this.makeChkDesc(n2, typeDescriptor.m_fieldsObj[n3]);
            ++n3;
        }
        return n2;
    }

    private int makeChkDesc_class_clnt(int n2, TypeDescriptor typeDescriptor) {
        ByteUtil.setUB2(this.m_descBuf, n2, (short)typeDescriptor.m_cltnType);
        ByteUtil.setInt(this.m_descBuf, n2 += 2, typeDescriptor.getMaxCnt());
        n2 += 4;
        switch (typeDescriptor.m_cltnType) {
            case 3: {
                DBError.ECJDBC_UNSUPPORTED_TYPE.throwz(new Object[0]);
                break;
            }
            case 1: 
            case 2: {
                n2 = this.makeChkDesc(n2, typeDescriptor.m_arrObj);
            }
        }
        return n2;
    }

    private int makeChkDesc_class(int n2, TypeDescriptor typeDescriptor) {
        ByteUtil.setShort(this.m_descBuf, n2, (short)119);
        n2 += 2;
        boolean bl = false;
        if (typeDescriptor.m_objId == 4) {
            bl = true;
        }
        if (bl) {
            ByteUtil.setByte(this.m_descBuf, n2, (byte)1);
        } else {
            ByteUtil.setByte(this.m_descBuf, n2, (byte)0);
        }
        ++n2;
        n2 = bl ? this.makeChkDesc_class_clnt(n2, typeDescriptor) : this.makeChkDesc_class_normal(n2, typeDescriptor);
        return n2;
    }

    private int makeChkDesc(int n2, TypeDescriptor typeDescriptor) {
        switch (typeDescriptor.getDType()) {
            case 117: 
            case 122: {
                n2 = this.makeChkDesc_array(n2, typeDescriptor);
                break;
            }
            case 121: {
                n2 = this.makeChkDesc_record(n2, typeDescriptor);
                break;
            }
            case 119: {
                n2 = this.makeChkDesc_class(n2, typeDescriptor);
                break;
            }
            default: {
                n2 = this.makeChkDesc_buildin(n2, typeDescriptor);
            }
        }
        return n2;
    }

    public byte[] getClassDescChkInfo() {
        if (this.m_descBuf != null) {
            return this.m_descBuf;
        }
        int n2 = this.calcChkDescLen(this);
        this.m_descBuf = new byte[n2];
        this.makeChkDesc(0, this);
        return this.m_descBuf;
    }
}

