/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.util;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ReflectUtil {
    public static Object getValue(Object o, Field field) {
        try {
            boolean accessible = field.isAccessible();
            if (accessible) {
                return field.get(o);
            }
            field.setAccessible(true);
            Object value = field.get(o);
            field.setAccessible(false);
            return value;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isCurrentTypeOrParentType(Class<?> paramType, Class<?> parentType) {
        if (paramType == parentType) {
            return true;
        }
        Set<Class<?>> parentTypes = ReflectUtil.getParentTypes(paramType);
        return parentTypes.contains(parentType);
    }

    public static Set<Class<?>> getParentTypes(Class<?> paramType) {
        if (paramType == null) {
            return Collections.EMPTY_SET;
        }
        List<Class<?>> interfaces = Arrays.asList(paramType.getInterfaces());
        HashSet parents = new HashSet(interfaces);
        for (Class<?> anInterface : interfaces) {
            parents.addAll(ReflectUtil.getParentTypes(anInterface));
        }
        Class<?> superclass = paramType.getSuperclass();
        parents.add(superclass);
        parents.addAll(ReflectUtil.getParentTypes(superclass));
        return parents;
    }
}

