/*
 * Decompiled with CFR 0.152.
 */
package com.xugu.util;

import com.xugu.util.internal.Nullness;
import java.lang.reflect.Field;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Objects;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;

public class TimestampUtils {
    private static final char[][] NUMBERS;
    private static final HashMap<String, TimeZone> GMT_ZONES;
    private static final @Nullable Field DEFAULT_TIME_ZONE_FIELD;
    private static @Nullable TimeZone prevDefaultZoneFieldValue;
    private static @Nullable TimeZone defaultTimeZoneCache;
    private static final Calendar calendarWithUserTz;
    private static @Nullable Calendar calCache;
    private static @Nullable ZoneOffset calCacheZone;
    static long DATE_POSITIVE_INFINITY;
    static long DATE_NEGATIVE_INFINITY;

    private static Calendar getCalendar(ZoneOffset offset) {
        if (calCache != null && Objects.equals(offset, calCacheZone)) {
            return calCache;
        }
        String tzid = offset.getTotalSeconds() == 0 ? "UTC" : "GMT".concat(offset.getId());
        SimpleTimeZone syntheticTZ = new SimpleTimeZone(offset.getTotalSeconds() * 1000, tzid);
        calCache = new GregorianCalendar(syntheticTZ);
        calCacheZone = offset;
        return calCache;
    }

    private static ParsedTimestamp parseBackendTimestamp(String str) throws SQLException {
        char[] s = str.toCharArray();
        int slen = s.length;
        ParsedTimestamp result = new ParsedTimestamp();
        try {
            int numlength;
            char sep;
            int start = TimestampUtils.skipWhitespace(s, 0);
            int end = TimestampUtils.firstNonDigit(s, start);
            if (TimestampUtils.charAt(s, end) == '-') {
                result.hasDate = true;
                result.year = TimestampUtils.number(s, start, end);
                start = end + 1;
                end = TimestampUtils.firstNonDigit(s, start);
                result.month = TimestampUtils.number(s, start, end);
                sep = TimestampUtils.charAt(s, end);
                if (sep != '-') {
                    throw new NumberFormatException("Expected date to be dash-separated, got '" + sep + "'");
                }
                start = end + 1;
                end = TimestampUtils.firstNonDigit(s, start);
                result.day = TimestampUtils.number(s, start, end);
                start = TimestampUtils.skipWhitespace(s, end);
            }
            if (Character.isDigit(TimestampUtils.charAt(s, start))) {
                result.hasTime = true;
                end = TimestampUtils.firstNonDigit(s, start);
                result.hour = TimestampUtils.number(s, start, end);
                sep = TimestampUtils.charAt(s, end);
                if (sep != ':') {
                    throw new NumberFormatException("Expected time to be colon-separated, got '" + sep + "'");
                }
                start = end + 1;
                end = TimestampUtils.firstNonDigit(s, start);
                result.minute = TimestampUtils.number(s, start, end);
                sep = TimestampUtils.charAt(s, end);
                if (sep != ':') {
                    throw new NumberFormatException("Expected time to be colon-separated, got '" + sep + "'");
                }
                start = end + 1;
                end = TimestampUtils.firstNonDigit(s, start);
                result.second = TimestampUtils.number(s, start, end);
                start = end;
                if (TimestampUtils.charAt(s, end) == '.') {
                    end = TimestampUtils.firstNonDigit(s, end + 1);
                    int num = TimestampUtils.number(s, start + 1, end);
                    for (numlength = end - (start + 1); numlength < 9; ++numlength) {
                        num *= 10;
                    }
                    result.nanos = num;
                    start = end;
                }
                start = TimestampUtils.skipWhitespace(s, start);
            }
            if ((sep = TimestampUtils.charAt(s, start)) == '-' || sep == '+') {
                int tzmin;
                result.hasOffset = true;
                numlength = sep == '-' ? -1 : 1;
                end = TimestampUtils.firstNonDigit(s, start + 1);
                int tzhr = TimestampUtils.number(s, start + 1, end);
                start = end;
                sep = TimestampUtils.charAt(s, end);
                if (sep == ':') {
                    end = TimestampUtils.firstNonDigit(s, end + 1);
                    tzmin = TimestampUtils.number(s, start + 1, end);
                    start = end;
                } else {
                    tzmin = 0;
                }
                int tzsec = 0;
                sep = TimestampUtils.charAt(s, start);
                if (sep == ':') {
                    end = TimestampUtils.firstNonDigit(s, start + 1);
                    tzsec = TimestampUtils.number(s, start + 1, end);
                    start = end;
                }
                result.offset = ZoneOffset.ofHoursMinutesSeconds(numlength * tzhr, numlength * tzmin, numlength * tzsec);
                start = TimestampUtils.skipWhitespace(s, start);
            }
            if (result.hasDate && start < slen) {
                String eraString = new String(s, start, slen - start);
                if (eraString.startsWith("AD")) {
                    result.era = 1;
                    start += 2;
                } else if (eraString.startsWith("BC")) {
                    result.era = 0;
                    start += 2;
                }
            }
            if (start < slen) {
                throw new NumberFormatException("Trailing junk on timestamp: '" + new String(s, start, slen - start) + "'");
            }
            if (!result.hasTime && !result.hasDate) {
                throw new NumberFormatException("Timestamp has neither date nor time");
            }
            return result;
        }
        catch (NumberFormatException var12) {
            throw new SQLException("Bad value for type timestamp/date/time: {0}", str);
        }
    }

    public static @PolyNull Timestamp toTimestamp(@Nullable Calendar cal, @PolyNull String s) throws SQLException {
        if (s == null) {
            return null;
        }
        int slen = s.length();
        if (slen == 8 && s.equals("infinity")) {
            return new Timestamp(DATE_POSITIVE_INFINITY);
        }
        if (slen == 9 && s.equals("-infinity")) {
            return new Timestamp(DATE_NEGATIVE_INFINITY);
        }
        ParsedTimestamp ts = TimestampUtils.parseBackendTimestamp(s);
        Calendar useCal = ts.hasOffset ? TimestampUtils.getCalendar(ts.offset) : TimestampUtils.setupCalendar(cal);
        useCal.set(0, ts.era);
        useCal.set(1, ts.year);
        useCal.set(2, ts.month - 1);
        useCal.set(5, ts.day);
        useCal.set(11, ts.hour);
        useCal.set(12, ts.minute);
        useCal.set(13, ts.second);
        useCal.set(14, 0);
        Timestamp result = new Timestamp(useCal.getTimeInMillis());
        result.setNanos(ts.nanos);
        return result;
    }

    @Deprecated
    public OffsetDateTime toOffsetDateTime(Time t) {
        return t.toLocalTime().atDate(LocalDate.of(1970, 1, 1)).atOffset(ZoneOffset.UTC);
    }

    public static @PolyNull Time toTime(@Nullable Calendar cal, @PolyNull String s) throws SQLException {
        Calendar useCal;
        if (s == null) {
            return null;
        }
        ParsedTimestamp ts = TimestampUtils.parseBackendTimestamp(s);
        Calendar calendar = useCal = ts.hasOffset ? TimestampUtils.getCalendar(ts.offset) : TimestampUtils.setupCalendar(cal);
        if (!ts.hasOffset) {
            useCal.set(0, ts.era);
            useCal.set(1, ts.year);
            useCal.set(2, ts.month - 1);
            useCal.set(5, ts.day);
        } else {
            useCal.set(0, 1);
            useCal.set(1, 1970);
            useCal.set(2, 0);
            useCal.set(5, 1);
        }
        useCal.set(11, ts.hour);
        useCal.set(12, ts.minute);
        useCal.set(13, ts.second);
        useCal.set(14, 0);
        long timeMillis = useCal.getTimeInMillis() + (long)(ts.nanos / 1000000);
        return !ts.hasOffset && (ts.year != 1970 || ts.era != 1) ? TimestampUtils.convertToTime(timeMillis, useCal.getTimeZone()) : new Time(timeMillis);
    }

    public static Date toDate(@Nullable Calendar cal, @PolyNull String s) throws SQLException {
        Timestamp timestamp = TimestampUtils.toTimestamp(cal, s);
        return timestamp == null ? null : TimestampUtils.convertToDate(timestamp.getTime(), cal == null ? null : cal.getTimeZone());
    }

    private static Calendar setupCalendar(@Nullable Calendar cal) {
        TimeZone timeZone = cal == null ? null : cal.getTimeZone();
        return TimestampUtils.getSharedCalendar(timeZone);
    }

    public static Calendar getSharedCalendar(@Nullable TimeZone timeZone) {
        if (timeZone == null) {
            timeZone = TimestampUtils.getDefaultTz();
        }
        Calendar tmp = calendarWithUserTz;
        tmp.setTimeZone(timeZone);
        return tmp;
    }

    private static int skipWhitespace(char[] s, int start) {
        int slen = s.length;
        for (int i = start; i < slen; ++i) {
            if (Character.isSpace(s[i])) continue;
            return i;
        }
        return slen;
    }

    private static int firstNonDigit(char[] s, int start) {
        int slen = s.length;
        for (int i = start; i < slen; ++i) {
            if (Character.isDigit(s[i])) continue;
            return i;
        }
        return slen;
    }

    private static int number(char[] s, int start, int end) {
        if (start >= end) {
            throw new NumberFormatException();
        }
        int n = 0;
        for (int i = start; i < end; ++i) {
            n = 10 * n + (s[i] - 48);
        }
        return n;
    }

    private static char charAt(char[] s, int pos) {
        return pos >= 0 && pos < s.length ? s[pos] : (char)'\u0000';
    }

    private static TimeZone getDefaultTz() {
        TimeZone defaultTimeZone;
        if (DEFAULT_TIME_ZONE_FIELD != null) {
            try {
                defaultTimeZone = (TimeZone)DEFAULT_TIME_ZONE_FIELD.get(null);
                if (defaultTimeZone == prevDefaultZoneFieldValue) {
                    return Nullness.castNonNull(defaultTimeZoneCache);
                }
                prevDefaultZoneFieldValue = defaultTimeZone;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        defaultTimeZoneCache = defaultTimeZone = TimeZone.getDefault();
        return defaultTimeZone;
    }

    private static boolean isSimpleTimeZone(String id) {
        return id.startsWith("GMT") || id.startsWith("UTC");
    }

    public static Date convertToDate(long millis, @Nullable TimeZone tz) {
        if (millis > DATE_NEGATIVE_INFINITY && millis < DATE_POSITIVE_INFINITY) {
            if (tz == null) {
                tz = TimestampUtils.getDefaultTz();
            }
            if (TimestampUtils.isSimpleTimeZone(tz.getID())) {
                int offset = tz.getRawOffset();
                millis += (long)offset;
                millis = TimestampUtils.floorDiv(millis, 86400000L) * 86400000L;
                return new Date(millis -= (long)offset);
            }
            Calendar cal = calendarWithUserTz;
            cal.setTimeZone(tz);
            cal.setTimeInMillis(millis);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            return new Date(cal.getTimeInMillis());
        }
        return new Date(millis);
    }

    public static Time convertToTime(long millis, TimeZone tz) {
        if (tz == null) {
            tz = TimestampUtils.getDefaultTz();
        }
        if (TimestampUtils.isSimpleTimeZone(tz.getID())) {
            int offset = tz.getRawOffset();
            millis += (long)offset;
            millis = TimestampUtils.floorMod(millis, 86400000L);
            return new Time(millis -= (long)offset);
        }
        Calendar cal = calendarWithUserTz;
        cal.setTimeZone(tz);
        cal.setTimeInMillis(millis);
        cal.set(0, 1);
        cal.set(1, 1970);
        cal.set(2, 0);
        cal.set(5, 1);
        return new Time(cal.getTimeInMillis());
    }

    private static long floorDiv(long x, long y) {
        long r = x / y;
        if ((x ^ y) < 0L && r * y != x) {
            --r;
        }
        return r;
    }

    private static long floorMod(long x, long y) {
        return x - TimestampUtils.floorDiv(x, y) * y;
    }

    static {
        Object tzField;
        int i;
        GMT_ZONES = new HashMap();
        NUMBERS = new char[64][];
        for (i = 0; i < NUMBERS.length; ++i) {
            TimestampUtils.NUMBERS[i] = ((i < 10 ? "0" : "") + Integer.toString(i)).toCharArray();
        }
        for (i = -12; i <= 14; ++i) {
            String pgZoneName;
            TimeZone timeZone;
            if (i == 0) {
                timeZone = TimeZone.getTimeZone("GMT");
                pgZoneName = "GMT";
            } else {
                timeZone = TimeZone.getTimeZone("GMT" + (i <= 0 ? "+" : "-") + Math.abs(i));
                pgZoneName = "GMT" + (i >= 0 ? "+" : "-");
            }
            if (i == 0) {
                GMT_ZONES.put(pgZoneName, timeZone);
                continue;
            }
            GMT_ZONES.put(pgZoneName + Math.abs(i), timeZone);
            GMT_ZONES.put(pgZoneName + new String(NUMBERS[Math.abs(i)]), timeZone);
        }
        try {
            tzField = null;
        }
        catch (Exception var3) {
            tzField = null;
        }
        DEFAULT_TIME_ZONE_FIELD = tzField;
        calendarWithUserTz = new GregorianCalendar();
        DATE_POSITIVE_INFINITY = 9223372036825200000L;
        DATE_NEGATIVE_INFINITY = -9223372036832400000L;
    }

    private static class ParsedTimestamp {
        boolean hasDate = false;
        int era = 1;
        int year = 1970;
        int month = 1;
        boolean hasTime = false;
        int day = 1;
        int hour = 0;
        int minute = 0;
        int second = 0;
        int nanos = 0;
        boolean hasOffset = false;
        ZoneOffset offset = ZoneOffset.UTC;

        private ParsedTimestamp() {
        }
    }
}

