/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.client.observation;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationHandler;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.client.observation.ChatClientObservationContext;
import org.springframework.ai.chat.model.Generation;
import org.springframework.ai.content.Content;
import org.springframework.ai.observation.ObservabilityHelper;
import org.springframework.util.StringUtils;

public class ChatClientCompletionObservationHandler
implements ObservationHandler<ChatClientObservationContext> {
    private static final Logger logger = LoggerFactory.getLogger(ChatClientCompletionObservationHandler.class);

    public void onStop(ChatClientObservationContext context) {
        logger.info("Chat Client Completion:\n{}", (Object)ObservabilityHelper.concatenateStrings(this.completion(context)));
    }

    private List<String> completion(ChatClientObservationContext context) {
        if (context.getResponse() == null || context.getResponse().chatResponse() == null) {
            return List.of();
        }
        return context.getResponse().chatResponse().getResults().stream().map(Generation::getOutput).map(Content::getText).filter(StringUtils::hasText).toList();
    }

    public boolean supportsContext(Observation.Context context) {
        return context instanceof ChatClientObservationContext;
    }
}

