/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.metadata;

import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.metadata.EmptyRateLimit;
import org.springframework.ai.chat.metadata.EmptyUsage;
import org.springframework.ai.chat.metadata.PromptMetadata;
import org.springframework.ai.chat.metadata.RateLimit;
import org.springframework.ai.chat.metadata.Usage;
import org.springframework.ai.model.AbstractResponseMetadata;
import org.springframework.ai.model.ResponseMetadata;

public class ChatResponseMetadata
extends AbstractResponseMetadata
implements ResponseMetadata {
    private static final Logger logger = LoggerFactory.getLogger(ChatResponseMetadata.class);
    private String id = "";
    private String model = "";
    private RateLimit rateLimit = new EmptyRateLimit();
    private Usage usage = new EmptyUsage();
    private PromptMetadata promptMetadata = PromptMetadata.empty();

    public static Builder builder() {
        return new Builder();
    }

    public String getId() {
        return this.id;
    }

    public String getModel() {
        return this.model;
    }

    public RateLimit getRateLimit() {
        return this.rateLimit;
    }

    public Usage getUsage() {
        return this.usage;
    }

    public PromptMetadata getPromptMetadata() {
        return this.promptMetadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChatResponseMetadata)) {
            return false;
        }
        ChatResponseMetadata that = (ChatResponseMetadata)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.model, that.model) && Objects.equals(this.rateLimit, that.rateLimit) && Objects.equals(this.usage, that.usage) && Objects.equals(this.promptMetadata, that.promptMetadata);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.model, this.rateLimit, this.usage, this.promptMetadata);
    }

    public String toString() {
        return "{ id: %1$s, usage: %2$s, rateLimit: %3$s }".formatted(this.getId(), this.getUsage(), this.getRateLimit());
    }

    public static final class Builder {
        private final ChatResponseMetadata chatResponseMetadata = new ChatResponseMetadata();

        public Builder metadata(Map<String, Object> mapToCopy) {
            this.chatResponseMetadata.map.putAll(mapToCopy);
            return this;
        }

        public Builder keyValue(String key, Object value) {
            if (key == null) {
                throw new IllegalArgumentException("Key must not be null");
            }
            if (value != null) {
                this.chatResponseMetadata.map.put(key, value);
            } else {
                logger.debug("Ignore null value for key [{}]", (Object)key);
            }
            return this;
        }

        public Builder id(String id) {
            this.chatResponseMetadata.id = id;
            return this;
        }

        public Builder model(String model) {
            this.chatResponseMetadata.model = model;
            return this;
        }

        public Builder rateLimit(RateLimit rateLimit) {
            this.chatResponseMetadata.rateLimit = rateLimit;
            return this;
        }

        public Builder usage(Usage usage) {
            this.chatResponseMetadata.usage = usage;
            return this;
        }

        public Builder promptMetadata(PromptMetadata promptMetadata) {
            this.chatResponseMetadata.promptMetadata = promptMetadata;
            return this;
        }

        public ChatResponseMetadata build() {
            return this.chatResponseMetadata;
        }
    }
}

