/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public final class AlertTemplateUtil {
    private static final Logger log = LoggerFactory.getLogger(AlertTemplateUtil.class);
    private static final Pattern PATTERN = Pattern.compile("\\$\\{([\\w.]+)}");

    private AlertTemplateUtil() {
    }

    public static String render(String template, Map<String, Object> replaceData) {
        if (!StringUtils.hasText((String)template)) {
            return template;
        }
        if (replaceData == null) {
            log.warn("The render replace data is null.");
            return template;
        }
        try {
            Matcher matcher = PATTERN.matcher(template);
            StringBuilder builder = new StringBuilder();
            while (matcher.find()) {
                String propertyPath = matcher.group(1);
                Object objectValue = AlertTemplateUtil.getNestedProperty(replaceData, propertyPath);
                String value = objectValue != null ? objectValue.toString() : "NullValue";
                matcher.appendReplacement(builder, Matcher.quoteReplacement(value));
            }
            matcher.appendTail(builder);
            return builder.toString();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return template;
        }
    }

    private static Object getNestedProperty(Map<String, Object> replaceData, String propertyPath) {
        if (propertyPath == null || propertyPath.isEmpty()) {
            return null;
        }
        String[] parts = propertyPath.split("\\.");
        Object current = replaceData.get(parts[0]);
        if (current == null) {
            return null;
        }
        if (parts.length == 1) {
            return current;
        }
        for (int i = 1; i < parts.length; ++i) {
            if ((current = AlertTemplateUtil.getPropertyValue(current, parts[i])) != null) continue;
            return null;
        }
        return current;
    }

    private static Object getPropertyValue(Object obj, String propertyName) {
        if (obj == null || propertyName == null) {
            return null;
        }
        try {
            if (obj instanceof Map) {
                return ((Map)obj).get(propertyName);
            }
            Class<?> clazz = obj.getClass();
            String getterName = "get" + AlertTemplateUtil.capitalize(propertyName);
            String booleanGetterName = "is" + AlertTemplateUtil.capitalize(propertyName);
            try {
                Method getter = clazz.getMethod(getterName, new Class[0]);
                return getter.invoke(obj, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                try {
                    Method booleanGetter = clazz.getMethod(booleanGetterName, new Class[0]);
                    return booleanGetter.invoke(obj, new Object[0]);
                }
                catch (NoSuchMethodException booleanGetter) {
                    try {
                        Field field = clazz.getDeclaredField(propertyName);
                        field.setAccessible(true);
                        return field.get(obj);
                    }
                    catch (NoSuchFieldException field) {
                        for (Class<?> superClass = clazz.getSuperclass(); superClass != null && !superClass.equals(Object.class); superClass = superClass.getSuperclass()) {
                            try {
                                Field field2 = superClass.getDeclaredField(propertyName);
                                field2.setAccessible(true);
                                return field2.get(obj);
                            }
                            catch (NoSuchFieldException noSuchFieldException) {
                                continue;
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            log.debug("Failed to access property '{}' on object of type {}: {}", new Object[]{propertyName, obj.getClass().getSimpleName(), e.getMessage()});
        }
        return null;
    }

    private static String capitalize(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }
}

