/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.tasks;

import io.questdb.Telemetry;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableWriter;
import io.questdb.griffin.QueryBuilder;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.ObjectFactory;
import io.questdb.tasks.AbstractTelemetryTask;

public class TelemetryTask
implements AbstractTelemetryTask {
    public static final String NAME = "TABLE TELEMETRY";
    public static final String TABLE_NAME = "telemetry";
    private static final Log LOG = LogFactory.getLog(TelemetryTask.class);
    public static final Telemetry.TelemetryTypeBuilder<TelemetryTask> TELEMETRY = configuration -> new Telemetry.TelemetryType<TelemetryTask>(){
        private final TelemetryTask systemStatusTask = new TelemetryTask();

        @Override
        public QueryBuilder getCreateSql(QueryBuilder builder) {
            return builder.$("CREATE TABLE IF NOT EXISTS \"").$(TelemetryTask.TABLE_NAME).$("\" (created TIMESTAMP, event SHORT, origin SHORT) TIMESTAMP(created) PARTITION BY DAY TTL 1 WEEK BYPASS WAL");
        }

        @Override
        public String getName() {
            return TelemetryTask.NAME;
        }

        @Override
        public String getTableName() {
            return TelemetryTask.TABLE_NAME;
        }

        @Override
        public ObjectFactory<TelemetryTask> getTaskFactory() {
            return () -> new TelemetryTask();
        }

        @Override
        public void logStatus(TableWriter writer, short systemStatus, long micros) {
            this.systemStatusTask.origin = 1;
            this.systemStatusTask.event = systemStatus;
            this.systemStatusTask.writeTo(writer, micros);
            writer.commit();
        }

        @Override
        public boolean shouldLogClasses() {
            return true;
        }
    };
    private short event;
    private short origin;
    private long queueCursor;

    private TelemetryTask() {
    }

    public static void store(Telemetry<TelemetryTask> telemetry, short origin, short event) {
        TelemetryTask task = telemetry.nextTask();
        if (task != null) {
            task.origin = origin;
            task.event = event;
            telemetry.store(task);
        }
    }

    @Override
    public long getQueueCursor() {
        return this.queueCursor;
    }

    @Override
    public void setQueueCursor(long cursor) {
        this.queueCursor = cursor;
    }

    @Override
    public void writeTo(TableWriter writer, long timestamp) {
        try {
            TableWriter.Row row = writer.newRow(timestamp);
            row.putShort(1, this.event);
            row.putShort(2, this.origin);
            row.append();
        }
        catch (CairoException e) {
            LOG.error().$("Could not insert a new ").$(TABLE_NAME).$(" row [errno=").$(e.getErrno()).$(", error=").$safe(e.getFlyweightMessage()).$(']').$();
        }
    }
}

