/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.tasks;

import io.questdb.cairo.sql.ExecutionCircuitBreaker;
import io.questdb.cairo.sql.PageFrameAddressCache;
import io.questdb.cairo.sql.PageFrameMemoryPool;
import io.questdb.griffin.engine.functions.geohash.GeoHashNative;
import io.questdb.mp.CountDownLatchSPI;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.QuietCloseable;

public class LatestByTask
implements QuietCloseable,
Mutable {
    private final PageFrameMemoryPool frameMemoryPool = new PageFrameMemoryPool(1);
    private long argsAddress;
    private ExecutionCircuitBreaker circuitBreaker;
    private CountDownLatchSPI doneLatch;
    private int frameIndex;
    private int hashColumnIndex;
    private int hashColumnType;
    private long keyBaseAddress;
    private long keysMemorySize;
    private long prefixesAddress;
    private long prefixesCount;
    private long rowHi;
    private long rowLo;
    private long unIndexedNullCount;
    private long valueBaseAddress;
    private int valueBlockCapacity;
    private long valuesMemorySize;

    @Override
    public void clear() {
        this.frameMemoryPool.clear();
    }

    @Override
    public void close() {
        Misc.free(this.frameMemoryPool);
    }

    public void of(PageFrameAddressCache addressCache, long keyBaseAddress, long keysMemorySize, long valueBaseAddress, long valuesMemorySize, long argsAddress, long unIndexedNullCount, long rowHi, long rowLo, int frameIndex, int valueBlockCapacity, int hashColumnIndex, int hashColumnType, long prefixesAddress, long prefixesCount, CountDownLatchSPI doneLatch, ExecutionCircuitBreaker circuitBreaker) {
        this.frameMemoryPool.of(addressCache);
        this.keyBaseAddress = keyBaseAddress;
        this.keysMemorySize = keysMemorySize;
        this.valueBaseAddress = valueBaseAddress;
        this.valuesMemorySize = valuesMemorySize;
        this.argsAddress = argsAddress;
        this.unIndexedNullCount = unIndexedNullCount;
        this.rowHi = rowHi;
        this.rowLo = rowLo;
        this.frameIndex = frameIndex;
        this.valueBlockCapacity = valueBlockCapacity;
        this.hashColumnIndex = hashColumnIndex;
        this.hashColumnType = hashColumnType;
        this.prefixesAddress = prefixesAddress;
        this.prefixesCount = prefixesCount;
        this.doneLatch = doneLatch;
        this.circuitBreaker = circuitBreaker;
    }

    public boolean run() {
        try {
            if (!this.circuitBreaker.checkIfTripped()) {
                GeoHashNative.latestByAndFilterPrefix(this.frameMemoryPool, this.keyBaseAddress, this.keysMemorySize, this.valueBaseAddress, this.valuesMemorySize, this.argsAddress, this.unIndexedNullCount, this.rowHi, this.rowLo, this.frameIndex, this.valueBlockCapacity, this.hashColumnIndex, this.hashColumnType, this.prefixesAddress, this.prefixesCount);
            }
            this.doneLatch.countDown();
            boolean bl = true;
            return bl;
        }
        finally {
            this.frameMemoryPool.close();
        }
    }
}

