/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.filewatch;

import io.questdb.FileEventCallback;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.SOCountDownLatch;
import io.questdb.std.QuietCloseable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public abstract class FileWatcher
implements QuietCloseable {
    private static final long DEBOUNCE_PERIOD_NANOS = TimeUnit.MILLISECONDS.toNanos(100L);
    private static final Log LOG = LogFactory.getLog(FileWatcher.class);
    protected final DebouncingCallback callback;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final SOCountDownLatch haltedLatch = new SOCountDownLatch(2);
    private final Thread reloadThread;
    private final AtomicBoolean started = new AtomicBoolean();
    private final SOCountDownLatch startedLatch = new SOCountDownLatch(1);

    public FileWatcher(@NotNull FileEventCallback callback) {
        this.callback = new DebouncingCallback(callback, DEBOUNCE_PERIOD_NANOS);
        this.reloadThread = new Thread(() -> {
            try {
                while (true) {
                    if (this.closed.get()) {
                        return;
                    }
                    this.waitForChange();
                    continue;
                    break;
                }
            }
            catch (Exception exc) {
                LOG.error().$(exc).$();
                return;
            }
            finally {
                this.haltedLatch.countDown();
                LOG.info().$("filewatcher poller thread closed").$();
            }
        });
    }

    @Override
    public void close() {
        this.halt();
    }

    public void halt() {
        if (this.closed.compareAndSet(false, true) && this.started.compareAndSet(true, false)) {
            this.startedLatch.await();
            this.releaseWait();
            this.callback.close();
            this.haltedLatch.await();
            this._close();
        }
    }

    public void start() {
        if (!this.closed.get() && this.started.compareAndSet(false, true)) {
            this.callback.start();
            this.reloadThread.start();
            this.startedLatch.countDown();
        }
    }

    protected abstract void _close();

    protected boolean isClosed() {
        return this.closed.get();
    }

    protected abstract void releaseWait();

    protected abstract void waitForChange();

    public class DebouncingCallback
    implements FileEventCallback,
    QuietCloseable {
        private final long debouncePeriodNanos;
        private final FileEventCallback delegate;
        private final Object lock = new Object();
        private boolean closed = false;
        private long notifyAt;

        public DebouncingCallback(FileEventCallback delegate, long debouncePeriodNanos) {
            this.delegate = delegate;
            this.debouncePeriodNanos = debouncePeriodNanos;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Object object = this.lock;
            synchronized (object) {
                this.closed = true;
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFileEvent() {
            Object object = this.lock;
            synchronized (object) {
                this.notifyAt = System.nanoTime() + this.debouncePeriodNanos;
                this.lock.notifyAll();
            }
        }

        private void start() {
            this.notifyAt = Long.MAX_VALUE + System.nanoTime();
            Thread thread = new Thread(() -> {
                Object object = this.lock;
                synchronized (object) {
                    block6: while (true) {
                        while (true) {
                            if (this.closed) {
                                FileWatcher.this.haltedLatch.countDown();
                                return;
                            }
                            long now = System.nanoTime();
                            long waitNanos = this.notifyAt - now;
                            long waitMillis = waitNanos / 1000000L;
                            try {
                                if (waitMillis > 0L) {
                                    this.lock.wait(waitMillis);
                                    continue block6;
                                }
                                this.delegate.onFileEvent();
                                this.notifyAt = Long.MAX_VALUE + now;
                                continue block6;
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                continue;
                            }
                            catch (Exception e) {
                                LOG.critical().$("error while reloading server configuration").$(e).$();
                                continue;
                            }
                            break;
                        }
                    }
                }
            });
            thread.setName("config hot-reload debouncing thread");
            thread.start();
        }
    }
}

