/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.datetime;

import io.questdb.std.ConcurrentHashMap;
import io.questdb.std.datetime.DateLocale;
import io.questdb.std.datetime.TimeZoneRuleFactory;
import java.text.DateFormatSymbols;
import java.util.Locale;
import java.util.function.BiFunction;

public class DateLocaleFactory {
    public static final DateLocaleFactory INSTANCE = new DateLocaleFactory(TimeZoneRuleFactory.INSTANCE);
    private final ConcurrentHashMap<DateLocale> dateLocales = new ConcurrentHashMap();
    private final DateLocale dummyLocale = new DateLocale("en-quest", new DateFormatSymbols(), TimeZoneRuleFactory.INSTANCE);
    private final TimeZoneRuleFactory timeZoneRuleFactory;
    private final BiFunction<CharSequence, DateLocale, DateLocale> computeDateLocaleBiFunc = this::computeDateLocale;

    public DateLocaleFactory(TimeZoneRuleFactory timeZoneRuleFactory) {
        this.timeZoneRuleFactory = timeZoneRuleFactory;
        for (Locale l : Locale.getAvailableLocales()) {
            String tag = l.toLanguageTag();
            if ("und".equals(tag)) {
                tag = "";
            }
            this.dateLocales.put(tag, this.dummyLocale);
        }
    }

    public static void load() {
    }

    public DateLocale getLocale(CharSequence id) {
        DateLocale dateLocale = this.dateLocales.get(id);
        if (dateLocale == null) {
            return null;
        }
        if (dateLocale != this.dummyLocale) {
            return dateLocale;
        }
        return this.dateLocales.compute(id, this.computeDateLocaleBiFunc);
    }

    private DateLocale computeDateLocale(CharSequence key, DateLocale val) {
        if (val != this.dummyLocale) {
            return val;
        }
        Locale locale = Locale.forLanguageTag(key.toString());
        return new DateLocale(key.toString(), new DateFormatSymbols(locale), this.timeZoneRuleFactory);
    }
}

