/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.AbstractLowerCaseUtf8SequenceHashSet;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8String;
import io.questdb.std.str.Utf8s;
import java.util.Arrays;

public class LowerCaseUtf8SequenceIntHashMap
extends AbstractLowerCaseUtf8SequenceHashSet {
    public static final int NO_ENTRY_VALUE = -1;
    private final ObjList<Utf8String> list;
    private final int noEntryValue;
    private int[] values;

    public LowerCaseUtf8SequenceIntHashMap() {
        this(8);
    }

    public LowerCaseUtf8SequenceIntHashMap(int initialCapacity) {
        this(initialCapacity, 0.5, -1);
    }

    private LowerCaseUtf8SequenceIntHashMap(int initialCapacity, double loadFactor, int noEntryValue) {
        super(initialCapacity, loadFactor);
        this.noEntryValue = noEntryValue;
        this.list = new ObjList(this.capacity);
        this.values = new int[this.keys.length];
        this.clear();
    }

    @Override
    public final void clear() {
        super.clear();
        this.list.clear();
        Arrays.fill(this.values, this.noEntryValue);
    }

    public int get(Utf8Sequence key) {
        return this.valueAt(this.keyIndex(key));
    }

    public ObjList<Utf8String> keys() {
        return this.list;
    }

    public boolean put(Utf8String key, int value) {
        return this.putAt(this.keyIndex(key), key, value);
    }

    public boolean put(Utf8Sequence key, int value) {
        return this.putAt(this.keyIndex(key), key, value);
    }

    public boolean putAt(int index, Utf8Sequence key, int value) {
        if (index < 0) {
            this.values[-index - 1] = value;
            return false;
        }
        Utf8String onHeapKey = Utf8String.newInstance(key);
        this.keys[index] = onHeapKey;
        this.hashCodes[index] = Utf8s.lowerCaseAsciiHashCode(key);
        this.values[index] = value;
        if (--this.free == 0) {
            this.rehash();
        }
        this.list.add(onHeapKey);
        return true;
    }

    public boolean putAt(int index, Utf8String key, int value) {
        if (index < 0) {
            this.values[-index - 1] = value;
            return false;
        }
        this.keys[index] = key;
        this.hashCodes[index] = Utf8s.lowerCaseAsciiHashCode(key);
        this.values[index] = value;
        if (--this.free == 0) {
            this.rehash();
        }
        this.list.add(key);
        return true;
    }

    @Override
    public void removeAt(int index) {
        if (index < 0) {
            Utf8Sequence key = this.keys[-index - 1];
            super.removeAt(index);
            this.list.remove(key);
        }
    }

    public int valueAt(int index) {
        return index < 0 ? this.valueAtQuick(index) : this.noEntryValue;
    }

    public int valueAtQuick(int index) {
        return this.values[-index - 1];
    }

    public int valueQuick(int index) {
        return this.get(this.list.getQuick(index));
    }

    private void rehash() {
        int newCapacity;
        int size = this.size();
        this.free = this.capacity = (newCapacity = this.capacity * 2);
        int len = Numbers.ceilPow2((int)((double)newCapacity / this.loadFactor));
        Utf8Sequence[] oldKeys = this.keys;
        int[] oldHashCodes = this.hashCodes;
        int[] oldValues = this.values;
        this.keys = new Utf8Sequence[len];
        this.hashCodes = new int[len];
        this.values = new int[len];
        Arrays.fill(this.keys, null);
        this.mask = len - 1;
        this.free -= size;
        int i = oldKeys.length;
        while (i-- > 0) {
            Utf8Sequence key = oldKeys[i];
            if (key == null) continue;
            int index = this.keyIndex(key);
            this.keys[index] = key;
            this.hashCodes[index] = oldHashCodes[i];
            this.values[index] = oldValues[i];
        }
    }

    @Override
    protected void erase(int index) {
        this.keys[index] = noEntryKey;
        this.hashCodes[index] = 0;
        this.values[index] = this.noEntryValue;
    }

    @Override
    protected void move(int from, int to) {
        this.keys[to] = this.keys[from];
        this.hashCodes[to] = this.hashCodes[from];
        this.values[to] = this.values[from];
        this.erase(from);
    }
}

