/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.LongSort;
import io.questdb.std.LongVec;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.Rnd;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.Sinkable;
import io.questdb.std.str.StringSink;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class LongList
implements Mutable,
LongVec,
Sinkable {
    private static final int DEFAULT_ARRAY_SIZE = 16;
    private static final long DEFAULT_NO_ENTRY_VALUE = -1L;
    private final int initialCapacity;
    private final long noEntryValue;
    private long[] data;
    private int pos = 0;

    public LongList() {
        this(16);
    }

    public LongList(int capacity) {
        this(capacity, -1L);
    }

    public LongList(int capacity, long noEntryValue) {
        this.initialCapacity = capacity;
        this.data = new long[capacity];
        this.noEntryValue = noEntryValue;
    }

    public LongList(LongList other) {
        this.initialCapacity = Math.max(other.size(), 16);
        this.data = new long[this.initialCapacity];
        this.setPos(other.size());
        System.arraycopy(other.data, 0, this.data, 0, this.pos);
        this.noEntryValue = other.noEntryValue;
    }

    public LongList(long[] other) {
        this.initialCapacity = other.length;
        this.data = new long[this.initialCapacity];
        this.setPos(other.length);
        System.arraycopy(other, 0, this.data, 0, this.pos);
        this.noEntryValue = -1L;
    }

    public void add(long value) {
        this.checkCapacity(this.pos + 1);
        this.data[this.pos++] = value;
    }

    public void add(long value0, long value1) {
        int n = this.pos;
        this.checkCapacity(n + 2);
        this.data[n++] = value0;
        this.data[n++] = value1;
        this.pos = n;
    }

    public void add(long value0, long value1, long value2, long value3) {
        int n = this.pos;
        this.checkCapacity(n + 4);
        this.data[n++] = value0;
        this.data[n++] = value1;
        this.data[n++] = value2;
        this.data[n++] = value3;
        this.pos = n;
    }

    public void add(long value0, long value1, long value2, long value3, long value4, long value5, long value6, long value7) {
        int n = this.pos;
        this.checkCapacity(n + 8);
        this.data[n++] = value0;
        this.data[n++] = value1;
        this.data[n++] = value2;
        this.data[n++] = value3;
        this.data[n++] = value4;
        this.data[n++] = value5;
        this.data[n++] = value6;
        this.data[n++] = value7;
        this.pos = n;
    }

    public void add(LongList that) {
        this.add(that, 0, that.size());
    }

    public void add(LongList that, int lo, int hi) {
        int p = this.pos;
        int s = hi - lo;
        this.checkCapacity(p + s);
        System.arraycopy(that.data, lo, this.data, p, s);
        this.pos += s;
    }

    public void add(int index, long element) {
        this.checkCapacity(++this.pos);
        System.arraycopy(this.data, index, this.data, index + 1, this.pos - index - 1);
        this.data[index] = element;
    }

    public void addAll(LongList that) {
        int p = this.pos;
        int s = that.size();
        this.setPos(p + s);
        System.arraycopy(that.data, 0, this.data, p, s);
    }

    public void arrayCopy(int srcPos, int dstPos, int length) {
        System.arraycopy(this.data, srcPos, this.data, dstPos, length);
    }

    public int binarySearch(long value, int scanDir) {
        int low = 0;
        int high = this.pos - 1;
        while (high - low > 65) {
            int mid = low + high >>> 1;
            long midVal = this.data[mid];
            if (midVal < value) {
                low = mid;
                continue;
            }
            if (midVal > value) {
                high = mid - 1;
                continue;
            }
            return scanDir == -1 ? this.scrollUp(mid, midVal) : this.scrollDown(mid, high, midVal);
        }
        return scanDir == -1 ? this.scanUp(value, low, high + 1) : this.scanDown(value, low, high + 1);
    }

    public int binarySearchBlock(int shl, long value, int scanDir) {
        return this.binarySearchBlock(0, shl, value, scanDir);
    }

    public int binarySearchBlock(int offset, int shl, long value, int scanDir) {
        int low = offset >> shl;
        int high = this.pos - 1 >> shl;
        while (high - low > 65) {
            int mid = low + high >>> 1;
            long midVal = this.data[mid << shl];
            if (midVal < value) {
                low = mid;
                continue;
            }
            if (midVal > value) {
                high = mid - 1;
                continue;
            }
            return scanDir == -1 ? this.scrollUpBlock(shl, mid, midVal) : this.scrollDownBlock(shl, mid, high, midVal);
        }
        return scanDir == -1 ? this.scanUpBlock(shl, value, low, high + 1) : this.scanDownBlock(shl, value, low, high + 1);
    }

    public int capacity() {
        return this.data.length;
    }

    public void checkCapacity(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Negative capacity. Integer overflow may be?");
        }
        int l = this.data.length;
        if (capacity > l) {
            int newCap = Math.max(l << 1, capacity);
            this.data = Arrays.copyOf(this.data, newCap);
        }
    }

    @Override
    public void clear() {
        this.pos = 0;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof LongList && this.equals((LongList)that);
    }

    public void erase() {
        this.pos = 0;
        Arrays.fill(this.data, this.noEntryValue);
    }

    public void extendAndSet(int index, long value) {
        this.checkCapacity(index + 1);
        if (index >= this.pos) {
            this.pos = index + 1;
        }
        this.data[index] = value;
    }

    public void fill(int from, int to, long value) {
        Arrays.fill(this.data, from, to, value);
    }

    public long get(int index) {
        if (index < this.pos) {
            return this.data[index];
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    public long getAndSetQuick(int index, long value) {
        long v = this.getQuick(index);
        this.data[index] = value;
        return v;
    }

    public long getLast() {
        if (this.pos > 0) {
            return this.data[this.pos - 1];
        }
        return this.noEntryValue;
    }

    @Override
    public long getQuick(int index) {
        return this.data[index];
    }

    public int hashCode() {
        long hashCode = 1L;
        int n = this.pos;
        for (int i = 0; i < n; ++i) {
            long v = this.getQuick(i);
            hashCode = 31L * hashCode + (v == this.noEntryValue ? 0L : v);
        }
        return (int)hashCode;
    }

    public void increment(int index) {
        this.data[index] = this.data[index] + 1L;
    }

    public int indexOf(long o) {
        int n = this.pos;
        for (int i = 0; i < n; ++i) {
            if (o != this.getQuick(i)) continue;
            return i;
        }
        return -1;
    }

    public void insert(int index, int length) {
        this.checkCapacity(this.pos + length);
        if (this.pos > index) {
            System.arraycopy(this.data, index, this.data, index + length, this.pos - index);
        }
        this.pos += length;
    }

    public void insertFromSource(int index, LongList src, int srcLo, int srcHi) {
        assert (index > -1 && index < this.pos + 1 && srcLo > -1 && srcHi - 1 < src.size());
        int len = srcHi - srcLo;
        if (len > 0) {
            this.insert(index, len);
            System.arraycopy(src.data, srcLo, this.data, index, len);
        }
    }

    @Override
    public LongVec newInstance() {
        LongList newList = new LongList(this.size());
        newList.setPos(this.pos);
        return newList;
    }

    public void remove(long v) {
        int index = this.indexOf(v);
        if (index > -1) {
            this.removeIndex(index);
        }
    }

    public void removeIndex(int index) {
        if (this.pos < 1 || index >= this.pos) {
            return;
        }
        int move = this.pos - index - 1;
        if (move > 0) {
            System.arraycopy(this.data, index + 1, this.data, index, move);
        }
        this.data[--this.pos] = this.noEntryValue;
    }

    public void removeIndexBlock(int index, int slotSize) {
        if (this.pos < 1 || index >= this.pos) {
            return;
        }
        int move = this.pos - index - slotSize;
        if (move > 0) {
            System.arraycopy(this.data, index + slotSize, this.data, index, move);
        }
        this.pos -= slotSize;
        Arrays.fill(this.data, this.pos, this.pos + slotSize, this.noEntryValue);
    }

    public void restoreInitialCapacity() {
        this.data = new long[this.initialCapacity];
        this.pos = 0;
    }

    public void reverse() {
        int n = this.size();
        int m = n / 2;
        for (int i = 0; i < m; ++i) {
            long tmp = this.data[i];
            this.data[i] = this.data[n - i - 1];
            this.data[n - i - 1] = tmp;
        }
    }

    public void seed(int capacity, long value) {
        this.checkCapacity(capacity);
        this.pos = capacity;
        this.fill(0, capacity, value);
    }

    public void seed(int fromIndex, int count, long value) {
        int capacity = fromIndex + count;
        this.checkCapacity(capacity);
        Arrays.fill(this.data, fromIndex, capacity, value);
    }

    public void set(int index, long element) {
        if (index < this.pos) {
            this.data[index] = element;
            return;
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    public void setAll(int capacity, long value) {
        this.checkCapacity(capacity);
        this.pos = capacity;
        Arrays.fill(this.data, value);
    }

    public void setLast(long value) {
        if (this.pos > 0) {
            this.data[this.pos - 1] = value;
        }
    }

    public final void setPos(int pos) {
        this.checkCapacity(pos);
        this.pos = pos;
    }

    @Override
    public void setQuick(int index, long value) {
        assert (index < this.pos);
        this.data[index] = value;
    }

    public void shuffle(Rnd rnd, int sh) {
        int size;
        for (int i = size = this.size() >> sh; i > 1; --i) {
            this.swap(i - 1, rnd.nextInt(i), sh);
        }
    }

    public int size() {
        return this.pos;
    }

    public void sort() {
        LongSort.sort(this, 0, this.size() - 1);
    }

    public LongList subset(int lo, int hi) {
        int _hi = Math.min(hi, this.pos);
        LongList that = new LongList(_hi - lo);
        System.arraycopy(this.data, lo, that.data, 0, _hi - lo);
        that.pos = _hi - lo;
        return that;
    }

    public void swap(int i, int j, int shl) {
        int k = 1 << shl;
        for (int k1 = 0; k1 < k; ++k1) {
            int ii = (i << shl) + k1;
            int ji = (j << shl) + k1;
            long jv = this.getQuick(ji);
            this.setQuick(ji, this.getQuick(ii));
            this.setQuick(ii, jv);
        }
    }

    @Override
    public void toSink(@NotNull CharSink<?> sink) {
        sink.putAscii('[');
        int k = this.pos;
        for (int i = 0; i < k; ++i) {
            if (i > 0) {
                sink.putAscii(',');
            }
            sink.put(this.get(i));
        }
        sink.putAscii(']');
    }

    public String toString() {
        StringSink sink = Misc.getThreadLocalSink();
        sink.putAscii('[');
        int k = Math.min(this.pos, 100);
        for (int i = 0; i < k; ++i) {
            if (i > 0) {
                sink.putAscii(',');
            }
            sink.put(this.get(i));
        }
        if (this.pos > 100) {
            sink.putAscii(", .. ");
        }
        sink.putAscii(']');
        return ((Object)sink).toString();
    }

    public void zero(int value) {
        Arrays.fill(this.data, 0, this.pos, (long)value);
    }

    private boolean equals(LongList that) {
        if (this.pos != that.pos) {
            return false;
        }
        if (this.noEntryValue != that.noEntryValue) {
            return false;
        }
        int n = this.pos;
        for (int i = 0; i < n; ++i) {
            if (this.getQuick(i) == that.getQuick(i)) continue;
            return false;
        }
        return true;
    }

    private int scanDown(long v, int low, int high) {
        for (int i = high - 1; i >= low; --i) {
            long that = this.data[i];
            if (that == v) {
                return i;
            }
            if (that >= v) continue;
            return -(i + 2);
        }
        return -(low + 1);
    }

    private int scanDownBlock(int shl, long v, int low, int high) {
        for (int i = high - 1; i >= low; --i) {
            long that = this.data[i << shl];
            if (that == v) {
                return i << shl;
            }
            if (that >= v) continue;
            return -((i + 1 << shl) + 1);
        }
        return -((low << shl) + 1);
    }

    private int scanUp(long value, int low, int high) {
        for (int i = low; i < high; ++i) {
            long that = this.data[i];
            if (that == value) {
                return i;
            }
            if (that <= value) continue;
            return -(i + 1);
        }
        return -(high + 1);
    }

    private int scanUpBlock(int shl, long value, int low, int high) {
        for (int i = low; i < high; ++i) {
            long that = this.data[i << shl];
            if (that == value) {
                return i << shl;
            }
            if (that <= value) continue;
            return -((i << shl) + 1);
        }
        return -((high << shl) + 1);
    }

    private int scrollDown(int low, int high, long value) {
        do {
            if (low < high) continue;
            return low;
        } while (this.data[++low] == value);
        return low - 1;
    }

    private int scrollDownBlock(int shl, int low, int high, long value) {
        do {
            if (low < high) continue;
            return low << shl;
        } while (this.data[++low << shl] == value);
        return low - 1 << shl;
    }

    private int scrollUp(int high, long value) {
        do {
            if (high > 0) continue;
            return 0;
        } while (this.data[--high] == value);
        return high + 1;
    }

    private int scrollUpBlock(int shl, int high, long value) {
        do {
            if (high > 0) continue;
            return 0;
        } while (this.data[--high << shl] == value);
        return high + 1 << shl;
    }
}

